/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import java.util.Objects;

final class Group {
    private final String groupPrefix;
    private final int order;

    Group(String groupPrefix, int encounterOrder) {
        this.groupPrefix = Objects.requireNonNull(groupPrefix);
        this.order = encounterOrder;
        if (this.order < 0) {
            throw new IllegalArgumentException("Encounter order cannot be negative");
        }
    }

    public String getPrefix() {
        return this.groupPrefix;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean matches(String importClass) {
        return "*".contentEquals(this.getPrefix()) || importClass.startsWith(this.getPrefix());
    }

    public int hashCode() {
        return this.getPrefix().hashCode() + this.getOrder();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Group) {
            Group g = (Group)obj;
            return this.getPrefix().contentEquals(g.getPrefix()) && this.getOrder() == g.getOrder();
        }
        return false;
    }
}

