/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.validator.handle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.validator.constraints.Length;
import net.polyv.common.v1.validator.handle.Validator;

public class LengthValidator
extends Validator {
    public LengthValidator() {
        this.currentClass = Length.class;
    }

    @Override
    protected String dealValidate(Annotation annotation, Field field, Object data, Class<?> ... groups) {
        if (data == null) {
            return null;
        }
        Length cast = (Length)Length.class.cast(annotation);
        if (this.showMsg(groups, cast.groups())) {
            int length;
            if (data instanceof CharSequence) {
                length = ((CharSequence)data).length();
            } else if (data instanceof List) {
                length = ((List)data).size();
            } else if (data.getClass().isArray()) {
                length = ((Object[])data).length;
            } else {
                throw new PloyvSdkException(Constant.ERROR_CODE, field.getName() + " Length validation exception");
            }
            return this.getValidMsg(cast, length);
        }
        return null;
    }

    private String getValidMsg(Length cast, long length) {
        return this.isValid(cast.min(), cast.max(), length) ? null : cast.message();
    }

    private boolean isValid(long min, long max, long length) {
        return length >= min && length <= max;
    }
}

