/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.oschina.j2cache.util.Serializer;
import net.sf.ehcache.CacheException;

public class JavaSerializer
implements Serializer {
    @Override
    public String name() {
        return "java";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(byte[] bits) throws IOException {
        if (bits == null) return null;
        if (bits.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bits);
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

