/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.util.Serializer;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTSerializer
implements Serializer {
    private FSTConfiguration fstConfiguration = FSTConfiguration.getDefaultConfiguration();

    public FSTSerializer() {
        this.fstConfiguration.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public String name() {
        return "fst";
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FSTObjectOutput fOut = new FSTObjectOutput((OutputStream)out, this.fstConfiguration);){
            fOut.writeObject(obj);
            fOut.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        if (bytes == null) return null;
        if (bytes.length == 0) {
            return null;
        }
        try (FSTObjectInput in = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes), this.fstConfiguration);){
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new CacheException(e);
        }
    }
}

