/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.utils;

import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.config.DbType;
import net.maku.generator.config.GenDataSource;
import net.maku.generator.config.query.AbstractQuery;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.entity.TableFieldEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenUtils.class);

    public static List<TableEntity> getTableList(GenDataSource datasource) {
        ArrayList<TableEntity> tableList = new ArrayList<TableEntity>();
        try {
            AbstractQuery query = datasource.getDbQuery();
            PreparedStatement preparedStatement = datasource.getConnection().prepareStatement(query.tableSql(null));
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                TableEntity table = new TableEntity();
                table.setTableName(rs.getString(query.tableName()));
                table.setTableComment(rs.getString(query.tableComment()));
                table.setDatasourceId(datasource.getId());
                tableList.add(table);
            }
            datasource.getConnection().close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tableList;
    }

    public static TableEntity getTable(GenDataSource datasource, String tableName) {
        try {
            AbstractQuery query = datasource.getDbQuery();
            PreparedStatement preparedStatement = datasource.getConnection().prepareStatement(query.tableSql(tableName));
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                TableEntity table = new TableEntity();
                table.setTableName(rs.getString(query.tableName()));
                table.setTableComment(rs.getString(query.tableComment()));
                table.setDatasourceId(datasource.getId());
                return table;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        throw new ServerException("\u6570\u636e\u8868\u4e0d\u5b58\u5728\uff1a" + tableName);
    }

    public static List<TableFieldEntity> getTableFieldList(GenDataSource datasource, Long tableId, String tableName) {
        ArrayList<TableFieldEntity> tableFieldList = new ArrayList<TableFieldEntity>();
        try {
            AbstractQuery query = datasource.getDbQuery();
            String tableFieldsSql = query.tableFieldsSql();
            if (datasource.getDbType() == DbType.Oracle) {
                DatabaseMetaData md = datasource.getConnection().getMetaData();
                tableFieldsSql = String.format(tableFieldsSql.replace("#schema", md.getUserName()), tableName);
            } else {
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            }
            PreparedStatement preparedStatement = datasource.getConnection().prepareStatement(tableFieldsSql);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                TableFieldEntity field = new TableFieldEntity();
                field.setTableId(tableId);
                field.setFieldName(rs.getString(query.fieldName()));
                String fieldType = rs.getString(query.fieldType());
                if (fieldType.contains(" ")) {
                    fieldType = fieldType.substring(0, fieldType.indexOf(" "));
                }
                field.setFieldType(fieldType);
                field.setFieldComment(rs.getString(query.fieldComment()));
                String key = rs.getString(query.fieldKey());
                field.setPrimaryPk(StringUtils.isNotBlank((CharSequence)key) && "PRI".equalsIgnoreCase(key));
                tableFieldList.add(field);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tableFieldList;
    }

    public static String getModuleName(String packageName) {
        return StrUtil.subAfter((CharSequence)packageName, (CharSequence)".", (boolean)true);
    }

    public static String getFunctionName(String tableName) {
        String functionName = StrUtil.subAfter((CharSequence)tableName, (CharSequence)"_", (boolean)true);
        if (StrUtil.isBlank((CharSequence)functionName)) {
            functionName = tableName;
        }
        return functionName;
    }

    public static String camelCase(boolean upperFirst, String tableName, String removePrefix, String removeSuffix) {
        String className = tableName;
        if (StrUtil.isNotBlank((CharSequence)removePrefix)) {
            className = StrUtil.removePrefix((CharSequence)tableName, (CharSequence)removePrefix);
        }
        if (StrUtil.isNotBlank((CharSequence)removeSuffix)) {
            className = StrUtil.removeSuffix((CharSequence)className, (CharSequence)removeSuffix);
        }
        if (upperFirst) {
            return NamingCase.toPascalCase((CharSequence)className);
        }
        return NamingCase.toCamelCase((CharSequence)className);
    }
}

