/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.config.GenDataSource;
import net.maku.generator.config.template.GeneratorConfig;
import net.maku.generator.config.template.ProjectInfo;
import net.maku.generator.dao.TableDao;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.enums.FormLayoutEnum;
import net.maku.generator.enums.GeneratorTypeEnum;
import net.maku.generator.enums.PageAuthEnum;
import net.maku.generator.enums.PageOpenEnum;
import net.maku.generator.enums.TableTypeEnum;
import net.maku.generator.service.DataSourceService;
import net.maku.generator.service.GenConfigService;
import net.maku.generator.service.TableFieldService;
import net.maku.generator.service.TableService;
import net.maku.generator.utils.GenUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TableServiceImpl
extends BaseServiceImpl<TableDao, TableEntity>
implements TableService {
    private final TableFieldService tableFieldService;
    private final DataSourceService dataSourceService;
    private final GeneratorConfig generatorConfig;
    private final GenConfigService genConfigService;

    @Override
    public PageResult<TableEntity> page(Query query) {
        IPage page = ((TableDao)this.baseMapper).selectPage(this.getPage(query), (Wrapper)this.getWrapper(query));
        return new PageResult<TableEntity>(page.getRecords(), page.getTotal());
    }

    @Override
    public List<TableEntity> list() {
        return ((TableDao)this.baseMapper).selectList((Wrapper)Wrappers.emptyWrapper());
    }

    @Override
    public TableEntity getByTableName(String tableName) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        return (TableEntity)((TableDao)this.baseMapper).selectOne((Wrapper)queryWrapper.eq(TableEntity::getTableName, (Object)tableName));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatchIds(Long[] ids) {
        ((TableDao)this.baseMapper).deleteBatchIds(Arrays.asList(ids));
        this.tableFieldService.deleteBatchTableIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tableImport(Long datasourceId, String tableName) {
        GenDataSource dataSource = this.dataSourceService.get(datasourceId);
        TableEntity table = this.getByTableName(tableName);
        if (table != null) {
            throw new ServerException(tableName + "\u5df2\u5b58\u5728");
        }
        table = GenUtils.getTable(dataSource, tableName);
        ProjectInfo projectInfo = this.genConfigService.info();
        table.setPackageName(projectInfo.getPackageName());
        table.setVersion(projectInfo.getVersion());
        table.setBackendPath(projectInfo.getBackendPath());
        table.setFrontendPath(projectInfo.getFrontendPath());
        table.setAuthor(projectInfo.getAuthor());
        table.setEmail(projectInfo.getEmail());
        table.setFormLayout(FormLayoutEnum.ONE.getValue());
        table.setGeneratorType(GeneratorTypeEnum.ZIP_DOWNLOAD.ordinal());
        table.setModuleName(projectInfo.getModuleName());
        String newTableName = StrUtil.removePrefix((CharSequence)tableName, (CharSequence)projectInfo.getTablePrefix());
        table.setFunctionName(GenUtils.getFunctionName(newTableName));
        table.setClassName(NamingCase.toPascalCase((CharSequence)newTableName));
        table.setTableType(TableTypeEnum.NORMAL.getValue());
        table.setTableOperation(Arrays.asList("query", "insert", "update", "delete", "export"));
        table.setAuthLevel(PageAuthEnum.PAGE.getValue());
        table.setOpenType(PageOpenEnum.Dialog.getValue());
        table.setRequestUrl("/" + table.getModuleName() + "/" + table.getFunctionName());
        table.setAuthority(table.getModuleName() + ":" + table.getFunctionName());
        table.setCreateTime(new Date());
        this.save(table);
        List<TableFieldEntity> tableFieldList = GenUtils.getTableFieldList(dataSource, table.getId(), table.getTableName());
        this.tableFieldService.initFieldList(tableFieldList);
        tableFieldList.forEach(arg_0 -> ((TableFieldService)this.tableFieldService).save(arg_0));
        try {
            dataSource.getConnection().close();
        }
        catch (SQLException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(Long id) {
        TableEntity table = (TableEntity)this.getById(id);
        GenDataSource datasource = this.dataSourceService.get(table.getDatasourceId());
        List<TableFieldEntity> dbTableFieldList = GenUtils.getTableFieldList(datasource, table.getId(), table.getTableName());
        if (dbTableFieldList.isEmpty()) {
            throw new ServerException("\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8868\uff1a" + table.getTableName());
        }
        List<String> dbTableFieldNameList = dbTableFieldList.stream().map(TableFieldEntity::getFieldName).toList();
        List<TableFieldEntity> tableFieldList = this.tableFieldService.getByTableId(id);
        Map tableFieldMap = tableFieldList.stream().collect(Collectors.toMap(TableFieldEntity::getFieldName, Function.identity()));
        this.tableFieldService.initFieldList(dbTableFieldList);
        dbTableFieldList.forEach(field -> {
            if (!tableFieldMap.containsKey(field.getFieldName())) {
                this.tableFieldService.save(field);
                return;
            }
            TableFieldEntity updateField = (TableFieldEntity)tableFieldMap.get(field.getFieldName());
            updateField.setPrimaryPk(field.isPrimaryPk());
            updateField.setFieldComment(field.getFieldComment());
            updateField.setFieldType(field.getFieldType());
            updateField.setAttrType(field.getAttrType());
            this.tableFieldService.updateById(updateField);
        });
        List<TableFieldEntity> delFieldList = tableFieldList.stream().filter(field -> !dbTableFieldNameList.contains(field.getFieldName())).toList();
        if (!delFieldList.isEmpty()) {
            List fieldIds = delFieldList.stream().map(TableFieldEntity::getId).collect(Collectors.toList());
            this.tableFieldService.removeBatchByIds(fieldIds);
        }
    }

    @Generated
    public TableServiceImpl(TableFieldService tableFieldService, DataSourceService dataSourceService, GeneratorConfig generatorConfig, GenConfigService genConfigService) {
        this.tableFieldService = tableFieldService;
        this.dataSourceService = dataSourceService;
        this.generatorConfig = generatorConfig;
        this.genConfigService = genConfigService;
    }
}

