/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.dao.TableFieldDao;
import net.maku.generator.entity.FieldTypeEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.enums.AutoFillEnum;
import net.maku.generator.service.FieldTypeService;
import net.maku.generator.service.TableFieldService;
import org.springframework.stereotype.Service;

@Service
public class TableFieldServiceImpl
extends BaseServiceImpl<TableFieldDao, TableFieldEntity>
implements TableFieldService {
    private final FieldTypeService fieldTypeService;

    @Override
    public List<TableFieldEntity> getByTableId(Long tableId) {
        return ((TableFieldDao)this.baseMapper).getByTableId(tableId);
    }

    @Override
    public void deleteBatchTableIds(Long[] tableIds) {
        ((TableFieldDao)this.baseMapper).deleteBatchTableIds(tableIds);
    }

    @Override
    public void updateTableField(Long tableId, List<TableFieldEntity> tableFieldList) {
        int sort = 0;
        for (TableFieldEntity tableField : tableFieldList) {
            tableField.setSort(sort++);
            this.updateById(tableField);
        }
    }

    @Override
    public void initFieldList(List<TableFieldEntity> tableFieldList) {
        Map<String, FieldTypeEntity> fieldTypeMap = this.fieldTypeService.getMap();
        int index = 0;
        for (TableFieldEntity field : tableFieldList) {
            field.setAttrName(StringUtils.underlineToCamel((String)field.getFieldName()));
            FieldTypeEntity fieldTypeMapping = fieldTypeMap.get(field.getFieldType().toLowerCase());
            if (fieldTypeMapping == null) {
                field.setAttrType("Object");
            } else {
                field.setAttrType(fieldTypeMapping.getAttrType());
                field.setPackageName(fieldTypeMapping.getPackageName());
            }
            if (StrUtil.equalsAnyIgnoreCase((CharSequence)field.getFieldName(), (CharSequence[])new CharSequence[]{"create_time", "create_date", "creator", "create_by", "deleted", "version"})) {
                field.setAutoFill(AutoFillEnum.INSERT.name());
            } else if (StrUtil.equalsAnyIgnoreCase((CharSequence)field.getFieldName(), (CharSequence[])new CharSequence[]{"update_time", "update_date", "updater", "update_by"})) {
                field.setAutoFill(AutoFillEnum.INSERT_UPDATE.name());
            } else {
                field.setAutoFill(AutoFillEnum.DEFAULT.name());
                if (!field.isPrimaryPk() && !StrUtil.equalsAny((CharSequence)field.getFieldName(), (CharSequence[])new CharSequence[]{"tenant_id"})) {
                    field.setFormItem(true);
                    field.setFormRequired(true);
                    field.setGridItem(true);
                }
            }
            field.setQueryType("=");
            field.setQueryFormType("input");
            field.setFormType("input");
            field.setSort(index++);
            field.setCreateTime(new Date());
        }
    }

    @Generated
    public TableFieldServiceImpl(FieldTypeService fieldTypeService) {
        this.fieldTypeService = fieldTypeService;
    }
}

