/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.dao.ProjectModifyDao;
import net.maku.generator.entity.ProjectModifyEntity;
import net.maku.generator.service.ProjectModifyService;
import net.maku.generator.utils.ProjectUtils;
import org.springframework.stereotype.Service;

@Service
public class ProjectModifyServiceImpl
extends BaseServiceImpl<ProjectModifyDao, ProjectModifyEntity>
implements ProjectModifyService {
    @Override
    public PageResult<ProjectModifyEntity> page(Query query) {
        IPage page = ((ProjectModifyDao)this.baseMapper).selectPage(this.getPage(query), (Wrapper)this.getWrapper(query));
        return new PageResult<ProjectModifyEntity>(page.getRecords(), page.getTotal());
    }

    @Override
    public byte[] download(ProjectModifyEntity project) throws IOException {
        File srcRoot = new File(project.getProjectPath());
        File destRoot = new File(ProjectUtils.getTmpDirPath(project.getModifyProjectName()));
        List exclusions = StrUtil.split((CharSequence)project.getExclusions(), (CharSequence)",");
        Map<String, String> replaceMap = this.getReplaceMap(project);
        ProjectUtils.copyDirectory(srcRoot, destRoot, exclusions, replaceMap);
        List suffixList = StrUtil.split((CharSequence)project.getModifySuffix(), (CharSequence)",");
        ProjectUtils.contentFormat(destRoot, suffixList, replaceMap);
        File zipFile = ZipUtil.zip((File)destRoot);
        byte[] data = FileUtil.readBytes((File)zipFile);
        FileUtil.clean((File)destRoot.getParentFile().getParentFile());
        return data;
    }

    private Map<String, String> getReplaceMap(ProjectModifyEntity project) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String srcPath = "src/main/java/" + project.getProjectPackage().replaceAll("\\.", "/");
        String destPath = "src/main/java/" + project.getModifyProjectPackage().replaceAll("\\.", "/");
        map.put(srcPath, destPath);
        map.put(project.getProjectPackage(), project.getModifyProjectPackage());
        map.put(project.getProjectCode(), project.getModifyProjectCode());
        map.put(StrUtil.upperFirst((CharSequence)project.getProjectCode()), StrUtil.upperFirst((CharSequence)project.getModifyProjectCode()));
        map.put(project.getProjectCode() + "-generator-", "maku-generator-");
        return map;
    }

    public boolean save(ProjectModifyEntity entity) {
        entity.setExclusions(".git,.idea,target,logs");
        entity.setModifySuffix("java,xml,yml,factories,md,txt");
        entity.setCreateTime(new Date());
        return super.save((Object)entity);
    }

    @Generated
    public ProjectModifyServiceImpl() {
    }
}

