/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.common.utils.DateUtils;
import net.maku.generator.config.template.GeneratorConfig;
import net.maku.generator.config.template.GeneratorData;
import net.maku.generator.config.template.TemplateInfo;
import net.maku.generator.entity.BaseClassEntity;
import net.maku.generator.entity.SubTableEntity;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.service.BaseClassService;
import net.maku.generator.service.DataSourceService;
import net.maku.generator.service.FieldTypeService;
import net.maku.generator.service.GeneratorService;
import net.maku.generator.service.TableFieldService;
import net.maku.generator.service.TableService;
import net.maku.generator.utils.TemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeneratorServiceImpl
implements GeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneratorServiceImpl.class);
    private final DataSourceService datasourceService;
    private final FieldTypeService fieldTypeService;
    private final BaseClassService baseClassService;
    private final GeneratorConfig generatorConfig;
    private final TableService tableService;
    private final TableFieldService tableFieldService;

    @Override
    public void downloadCode(Long tableId, ZipOutputStream zip) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        List<TemplateInfo> templates = this.generatorConfig.getTemplateConfig(dataModel);
        ArrayList<Map<String, Object>> subDataList = new ArrayList<Map<String, Object>>();
        List<GeneratorData> dataList = this.subGeneratorCode(tableId, subDataList);
        dataModel.put("subs", subDataList);
        for (TemplateInfo template : templates) {
            dataModel.put("templateName", template.getTemplateName());
            String content = TemplateUtils.getContent(template.getTemplateContent(), dataModel);
            String path = TemplateUtils.getContent(template.getGeneratorPath(), dataModel);
            dataList.add(new GeneratorData(path, content));
        }
        this.leftTreeGeneratorCode(dataModel, dataList);
        dataList.forEach(generatorData -> {
            try {
                zip.putNextEntry(new ZipEntry(generatorData.getPath()));
                IoUtil.writeUtf8((OutputStream)zip, (boolean)false, (Object[])new Object[]{generatorData.getContent()});
                zip.flush();
                zip.closeEntry();
            }
            catch (IOException e) {
                throw new ServerException("\u6a21\u677f\u5199\u5165\u5931\u8d25\uff1a" + generatorData.getPath(), e);
            }
        });
    }

    private List<GeneratorData> subGeneratorCode(Long tableId, List<Map<String, Object>> subDataList) {
        ArrayList<GeneratorData> dataList = new ArrayList<GeneratorData>();
        TableEntity table = (TableEntity)this.tableService.getById(tableId);
        List<SubTableEntity> subTable = table.getSubTable();
        if (subTable == null || subTable.isEmpty()) {
            return dataList;
        }
        List<TemplateInfo> subTemplates = this.generatorConfig.getSubTemplateConfig();
        for (SubTableEntity sub : subTable) {
            Map<String, Object> dataModel = this.getSubDataModel(sub.getTableName());
            dataModel.put("foreignKey", sub.getForeignKey());
            dataModel.put("ForeignKey", NamingCase.toPascalCase((CharSequence)sub.getForeignKey()));
            dataModel.put("mainRelation", sub.getMainRelation());
            dataModel.put("tableTitle", sub.getTableTitle());
            dataModel.put("backendPath", table.getBackendPath());
            dataModel.put("frontendPath", table.getFrontendPath());
            dataModel.put("functionName", table.getFunctionName());
            dataModel.put("subs", new ArrayList());
            for (TemplateInfo template : subTemplates) {
                dataModel.put("templateName", template.getTemplateName());
                String content = TemplateUtils.getContent(template.getTemplateContent(), dataModel);
                String path = TemplateUtils.getContent(template.getGeneratorPath(), dataModel);
                dataList.add(new GeneratorData(path, content));
            }
            subDataList.add(dataModel);
        }
        return dataList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generatorCode(Long tableId) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        ArrayList<Map<String, Object>> subDataList = new ArrayList<Map<String, Object>>();
        List<GeneratorData> dataList = this.subGeneratorCode(tableId, subDataList);
        dataModel.put("subs", subDataList);
        this.leftTreeGeneratorCode(dataModel, dataList);
        List<TemplateInfo> templates = this.generatorConfig.getTemplateConfig(dataModel);
        for (TemplateInfo template : templates) {
            dataModel.put("templateName", template.getTemplateName());
            String content = TemplateUtils.getContent(template.getTemplateContent(), dataModel);
            String path = TemplateUtils.getContent(template.getGeneratorPath(), dataModel);
            dataList.add(new GeneratorData(path, content));
        }
        dataList.forEach(generatorData -> FileUtil.writeUtf8String((String)generatorData.getContent(), (String)generatorData.getPath()));
    }

    private Map<String, Object> getDataModel(Long tableId) {
        TableEntity table = (TableEntity)this.tableService.getById(tableId);
        List<TableFieldEntity> fieldList = this.tableFieldService.getByTableId(tableId);
        table.setFieldList(fieldList);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String dbType = this.datasourceService.getDatabaseProductName(table.getDatasourceId());
        dataModel.put("dbType", dbType);
        dataModel.put("package", table.getPackageName());
        dataModel.put("packagePath", table.getPackageName().replace(".", File.separator));
        dataModel.put("version", table.getVersion());
        dataModel.put("moduleName", table.getModuleName());
        dataModel.put("ModuleName", StrUtil.upperFirst((CharSequence)table.getModuleName()));
        dataModel.put("functionName", table.getFunctionName());
        dataModel.put("FunctionName", StrUtil.upperFirst((CharSequence)table.getFunctionName()));
        dataModel.put("formLayout", table.getFormLayout());
        dataModel.put("author", table.getAuthor());
        dataModel.put("email", table.getEmail());
        dataModel.put("datetime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        dataModel.put("date", DateUtils.format(new Date(), "yyyy-MM-dd"));
        this.setFieldTypeList(dataModel, table);
        this.setBaseClass(dataModel, table);
        Set<String> importList = this.fieldTypeService.getPackageByTableId(table.getId());
        dataModel.put("importList", importList);
        dataModel.put("tableName", table.getTableName());
        dataModel.put("tableComment", table.getTableComment());
        dataModel.put("className", StrUtil.lowerFirst((CharSequence)table.getClassName()));
        dataModel.put("ClassName", table.getClassName());
        dataModel.put("fieldList", table.getFieldList());
        dataModel.put("tableType", table.getTableType());
        dataModel.put("tableOperation", table.getTableOperation());
        dataModel.put("authLevel", table.getAuthLevel());
        dataModel.put("openType", table.getOpenType());
        dataModel.put("requestUrl", table.getRequestUrl());
        dataModel.put("authority", table.getAuthority());
        dataModel.put("hasTree", table.getTableType() == 1 || table.getTableType() == 3);
        dataModel.put("treeId", StringUtils.underlineToCamel((String)table.getTreeId()));
        dataModel.put("treePid", StringUtils.underlineToCamel((String)table.getTreePid()));
        dataModel.put("treeLabel", StringUtils.underlineToCamel((String)table.getTreeLabel()));
        boolean hasLeftTree = table.getTableType() == 2 || table.getTableType() == 3;
        dataModel.put("hasLeftTree", hasLeftTree);
        dataModel.put("leftTitle", table.getLeftTitle());
        dataModel.put("leftFrom", table.getLeftFrom());
        dataModel.put("leftRequestUrl", table.getLeftUrl());
        dataModel.put("leftRelationField", StringUtils.underlineToCamel((String)table.getLeftRelationField()));
        if (hasLeftTree && table.getLeftFrom() == 0) {
            TableEntity leftTable = this.tableService.getByTableName(table.getLeftTableName());
            List<TableFieldEntity> leftFieldList = this.tableFieldService.getByTableId(leftTable.getId());
            leftTable.setFieldList(leftFieldList);
            dataModel.put("hasLeftFormDs", true);
            dataModel.put("leftTableId", leftTable.getId());
            dataModel.put("leftTreeId", StringUtils.underlineToCamel((String)leftTable.getTreeId()));
            dataModel.put("leftTreePid", StringUtils.underlineToCamel((String)leftTable.getTreePid()));
            dataModel.put("leftTreeLabel", StringUtils.underlineToCamel((String)leftTable.getTreeLabel()));
            dataModel.put("leftRequestUrl", leftTable.getRequestUrl());
            dataModel.put("functionNameLeft", leftTable.getFunctionName());
            dataModel.put("FunctionNameLeft", StrUtil.upperFirst((CharSequence)leftTable.getFunctionName()));
        }
        fieldList.forEach(field -> {
            if (field.isPrimaryPk()) {
                dataModel.put("primaryName", field.getAttrName());
                dataModel.put("primaryType", field.getAttrType());
            }
        });
        dataModel.put("backendPath", table.getBackendPath());
        dataModel.put("frontendPath", table.getFrontendPath());
        return dataModel;
    }

    private Map<String, Object> getSubDataModel(String tableName) {
        TableEntity table = this.tableService.getByTableName(tableName);
        List<TableFieldEntity> fieldList = this.tableFieldService.getByTableId(table.getId());
        table.setFieldList(fieldList);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String dbType = this.datasourceService.getDatabaseProductName(table.getDatasourceId());
        dataModel.put("dbType", dbType);
        dataModel.put("package", table.getPackageName());
        dataModel.put("packagePath", table.getPackageName().replace(".", File.separator));
        dataModel.put("version", table.getVersion());
        dataModel.put("moduleName", table.getModuleName());
        dataModel.put("ModuleName", StrUtil.upperFirst((CharSequence)table.getModuleName()));
        dataModel.put("functionName", table.getFunctionName());
        dataModel.put("FunctionName", StrUtil.upperFirst((CharSequence)table.getFunctionName()));
        dataModel.put("formLayout", table.getFormLayout());
        dataModel.put("hasSub", true);
        dataModel.put("author", table.getAuthor());
        dataModel.put("email", table.getEmail());
        dataModel.put("datetime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        dataModel.put("date", DateUtils.format(new Date(), "yyyy-MM-dd"));
        this.setFieldTypeList(dataModel, table);
        this.setBaseClass(dataModel, table);
        Set<String> importList = this.fieldTypeService.getPackageByTableId(table.getId());
        dataModel.put("importList", importList);
        dataModel.put("tableName", table.getTableName());
        dataModel.put("tableComment", table.getTableComment());
        dataModel.put("className", StrUtil.lowerFirst((CharSequence)table.getClassName()));
        dataModel.put("ClassName", table.getClassName());
        dataModel.put("fieldList", table.getFieldList());
        dataModel.put("tableType", table.getTableType());
        dataModel.put("tableOperation", table.getTableOperation());
        dataModel.put("authLevel", table.getAuthLevel());
        dataModel.put("openType", table.getOpenType());
        dataModel.put("requestUrl", table.getRequestUrl());
        dataModel.put("authority", table.getAuthority());
        dataModel.put("hasTree", table.getTableType() == 1 || table.getTableType() == 3);
        dataModel.put("treeId", table.getTreeId());
        dataModel.put("treePid", table.getTreePid());
        dataModel.put("treeLabel", table.getTreeLabel());
        return dataModel;
    }

    private void setBaseClass(Map<String, Object> dataModel, TableEntity table) {
        if (table.getBaseclassId() == null) {
            return;
        }
        BaseClassEntity baseClass = (BaseClassEntity)this.baseClassService.getById(table.getBaseclassId());
        baseClass.setPackageName(baseClass.getPackageName());
        dataModel.put("baseClass", baseClass);
        Object[] fields = baseClass.getFields().split(",");
        for (TableFieldEntity field : table.getFieldList()) {
            if (!ArrayUtil.contains((Object[])fields, (Object)field.getFieldName())) continue;
            field.setBaseField(true);
        }
    }

    private void setFieldTypeList(Map<String, Object> dataModel, TableEntity table) {
        ArrayList<TableFieldEntity> primaryList = new ArrayList<TableFieldEntity>();
        ArrayList<TableFieldEntity> formList = new ArrayList<TableFieldEntity>();
        ArrayList<TableFieldEntity> gridList = new ArrayList<TableFieldEntity>();
        ArrayList<TableFieldEntity> queryList = new ArrayList<TableFieldEntity>();
        for (TableFieldEntity field : table.getFieldList()) {
            if (field.isPrimaryPk()) {
                primaryList.add(field);
            }
            if (field.isFormItem()) {
                formList.add(field);
            }
            if (field.isGridItem()) {
                gridList.add(field);
            }
            if (!field.isQueryItem()) continue;
            queryList.add(field);
        }
        dataModel.put("primaryList", primaryList);
        dataModel.put("formList", formList);
        dataModel.put("gridList", gridList);
        dataModel.put("queryList", queryList);
        if (primaryList.isEmpty()) {
            throw new ServerException("\u8868[" + table.getTableName() + "]\u6ca1\u6709\u4e3b\u952e!");
        }
    }

    @Override
    public List<GeneratorData> preview(Long tableId) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        ArrayList<Map<String, Object>> subDataList = new ArrayList<Map<String, Object>>();
        List<GeneratorData> dataList = this.subGeneratorCode(tableId, subDataList);
        dataModel.put("subs", subDataList);
        this.leftTreeGeneratorCode(dataModel, dataList);
        List<TemplateInfo> templates = this.generatorConfig.getTemplateConfig(dataModel);
        for (TemplateInfo template : templates) {
            dataModel.put("templateName", template.getTemplateName());
            String content = TemplateUtils.getContent(template.getTemplateContent(), dataModel);
            String path = TemplateUtils.getContent(template.getGeneratorPath(), dataModel);
            dataList.add(new GeneratorData(path, content));
        }
        String backendPath = StrUtil.subBefore((CharSequence)dataModel.get("backendPath").toString(), (CharSequence)"/", (boolean)true);
        String frontendPath = StrUtil.subBefore((CharSequence)dataModel.get("frontendPath").toString(), (CharSequence)"/", (boolean)true);
        dataList.forEach(data -> {
            String path = data.getPath();
            path = StrUtil.removeAll((CharSequence)path, (CharSequence)backendPath);
            if (StrUtil.startWith((CharSequence)(path = StrUtil.removeAll((CharSequence)path, (CharSequence)frontendPath)), (CharSequence)"/")) {
                path = StrUtil.subAfter((CharSequence)path, (CharSequence)"/", (boolean)false);
            }
            data.setPath(path);
        });
        return dataList;
    }

    @Override
    public String menu(Long tableId) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        String templateContent = this.generatorConfig.getTemplateContent("sql/menu.sql.ftl");
        dataModel.put("templateName", "menu");
        return TemplateUtils.getContent(templateContent, dataModel);
    }

    private void leftTreeGeneratorCode(Map<String, Object> dataModel, List<GeneratorData> dataList) {
        if (ObjUtil.equal((Object)dataModel.get("hasLeftTree"), (Object)true) && ObjUtil.equal((Object)dataModel.get("leftFrom"), (Object)0)) {
            Map<String, Object> leftDataModel = this.getDataModel((Long)dataModel.get("leftTableId"));
            leftDataModel.put("hasLeftFormDs", true);
            leftDataModel.put("subs", new ArrayList());
            leftDataModel.put("backendPath", dataModel.get("backendPath"));
            leftDataModel.put("frontendPath", dataModel.get("frontendPath"));
            leftDataModel.put("leftTitle", dataModel.get("leftTitle"));
            leftDataModel.put("authority", dataModel.get("authority"));
            List<TemplateInfo> leftTemplates = this.generatorConfig.getTemplateConfig(leftDataModel);
            for (TemplateInfo template : leftTemplates) {
                leftDataModel.put("templateName", template.getTemplateName());
                String content = TemplateUtils.getContent(template.getTemplateContent(), leftDataModel);
                String path = TemplateUtils.getContent(template.getGeneratorPath(), leftDataModel);
                dataList.add(new GeneratorData(path, content));
            }
        }
    }

    @Generated
    public GeneratorServiceImpl(DataSourceService datasourceService, FieldTypeService fieldTypeService, BaseClassService baseClassService, GeneratorConfig generatorConfig, TableService tableService, TableFieldService tableFieldService) {
        this.datasourceService = datasourceService;
        this.fieldTypeService = fieldTypeService;
        this.baseClassService = baseClassService;
        this.generatorConfig = generatorConfig;
        this.tableService = tableService;
        this.tableFieldService = tableFieldService;
    }
}

