/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.common.utils.JsonUtils;
import net.maku.generator.config.template.ProjectInfo;
import net.maku.generator.dao.GenConfigDao;
import net.maku.generator.entity.GenConfigEntity;
import net.maku.generator.service.GenConfigService;
import org.springframework.stereotype.Service;

@Service
public class GenConfigServiceImpl
extends BaseServiceImpl<GenConfigDao, GenConfigEntity>
implements GenConfigService {
    private static final String CONFIG_KEY = "gen_config";

    @Override
    public ProjectInfo info() {
        GenConfigEntity entity = (GenConfigEntity)((GenConfigDao)this.baseMapper).selectOne((Wrapper)this.getWrapper());
        if (entity == null || StrUtil.isBlank((CharSequence)entity.getConfigValue())) {
            return new ProjectInfo();
        }
        return JsonUtils.parseObject(entity.getConfigValue(), ProjectInfo.class);
    }

    @Override
    public void update(ProjectInfo info) {
        GenConfigEntity entity = new GenConfigEntity();
        entity.setConfigValue(JsonUtils.toJsonString(info));
        ((GenConfigDao)this.baseMapper).update(entity, (Wrapper)this.getWrapper());
    }

    private LambdaQueryWrapper<GenConfigEntity> getWrapper() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(GenConfigEntity::getConfigKey, (Object)CONFIG_KEY);
        return queryWrapper;
    }
}

