/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.config.DbType;
import net.maku.generator.config.GenDataSource;
import net.maku.generator.dao.DataSourceDao;
import net.maku.generator.entity.DataSourceEntity;
import net.maku.generator.service.DataSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSourceServiceImpl
extends BaseServiceImpl<DataSourceDao, DataSourceEntity>
implements DataSourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    private final DataSource dataSource;

    @Override
    public PageResult<DataSourceEntity> page(Query query) {
        IPage page = ((DataSourceDao)this.baseMapper).selectPage(this.getPage(query), (Wrapper)this.getWrapper(query));
        return new PageResult<DataSourceEntity>(page.getRecords(), page.getTotal());
    }

    @Override
    public List<DataSourceEntity> getList() {
        return ((DataSourceDao)this.baseMapper).selectList((Wrapper)Wrappers.emptyWrapper());
    }

    @Override
    public String getDatabaseProductName(Long dataSourceId) {
        if (dataSourceId.intValue() == 0) {
            return DbType.MySQL.name();
        }
        return ((DataSourceEntity)this.getById(dataSourceId)).getDbType();
    }

    @Override
    public GenDataSource get(Long datasourceId) {
        GenDataSource info = null;
        if (datasourceId.intValue() == 0) {
            try {
                info = new GenDataSource(this.dataSource.getConnection());
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            info = new GenDataSource((DataSourceEntity)this.getById(datasourceId));
        }
        return info;
    }

    public boolean save(DataSourceEntity entity) {
        entity.setCreateTime(new Date());
        return super.save((Object)entity);
    }

    @Generated
    public DataSourceServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

