/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.controller;

import java.util.Arrays;
import java.util.Set;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.utils.Result;
import net.maku.generator.entity.FieldTypeEntity;
import net.maku.generator.service.FieldTypeService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"maku-generator/gen/fieldtype"})
public class FieldTypeController {
    private final FieldTypeService fieldTypeService;

    @GetMapping(value={"page"})
    public Result<PageResult<FieldTypeEntity>> page(Query query) {
        PageResult<FieldTypeEntity> page = this.fieldTypeService.page(query);
        return Result.ok(page);
    }

    @GetMapping(value={"{id}"})
    public Result<FieldTypeEntity> get(@PathVariable(value="id") Long id) {
        FieldTypeEntity data = (FieldTypeEntity)this.fieldTypeService.getById(id);
        return Result.ok(data);
    }

    @GetMapping(value={"list"})
    public Result<Set<String>> list() {
        Set<String> set = this.fieldTypeService.getList();
        return Result.ok(set);
    }

    @PostMapping
    public Result<String> save(@RequestBody FieldTypeEntity entity) {
        this.fieldTypeService.save(entity);
        return Result.ok();
    }

    @PutMapping
    public Result<String> update(@RequestBody FieldTypeEntity entity) {
        this.fieldTypeService.updateById(entity);
        return Result.ok();
    }

    @DeleteMapping
    public Result<String> delete(@RequestBody Long[] ids) {
        this.fieldTypeService.removeBatchByIds(Arrays.asList(ids));
        return Result.ok();
    }

    @Generated
    public FieldTypeController(FieldTypeService fieldTypeService) {
        this.fieldTypeService = fieldTypeService;
    }
}

