/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.controller;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.utils.Result;
import net.maku.generator.config.GenDataSource;
import net.maku.generator.entity.DataSourceEntity;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.service.DataSourceService;
import net.maku.generator.utils.DbUtils;
import net.maku.generator.utils.GenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"maku-generator/gen/datasource"})
public class DataSourceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceController.class);
    private final DataSourceService datasourceService;

    @GetMapping(value={"page"})
    public Result<PageResult<DataSourceEntity>> page(Query query) {
        PageResult<DataSourceEntity> page = this.datasourceService.page(query);
        return Result.ok(page);
    }

    @GetMapping(value={"list"})
    public Result<List<DataSourceEntity>> list() {
        List<DataSourceEntity> list = this.datasourceService.getList();
        return Result.ok(list);
    }

    @GetMapping(value={"{id}"})
    public Result<DataSourceEntity> get(@PathVariable(value="id") Long id) {
        DataSourceEntity data = (DataSourceEntity)this.datasourceService.getById(id);
        return Result.ok(data);
    }

    @GetMapping(value={"test/{id}"})
    public Result<String> test(@PathVariable(value="id") Long id) {
        try {
            DataSourceEntity entity = (DataSourceEntity)this.datasourceService.getById(id);
            DbUtils.getConnection(new GenDataSource(entity));
            return Result.ok("\u8fde\u63a5\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error("\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f");
        }
    }

    @PostMapping
    public Result<String> save(@RequestBody DataSourceEntity entity) {
        this.datasourceService.save(entity);
        return Result.ok();
    }

    @PutMapping
    public Result<String> update(@RequestBody DataSourceEntity entity) {
        this.datasourceService.updateById(entity);
        return Result.ok();
    }

    @DeleteMapping
    public Result<String> delete(@RequestBody Long[] ids) {
        this.datasourceService.removeBatchByIds(Arrays.asList(ids));
        return Result.ok();
    }

    @GetMapping(value={"table/list/{id}"})
    public Result<List<TableEntity>> tableList(@PathVariable(value="id") Long id) {
        try {
            GenDataSource datasource = this.datasourceService.get(id);
            List<TableEntity> tableList = GenUtils.getTableList(datasource);
            return Result.ok(tableList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error("\u6570\u636e\u6e90\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\uff01");
        }
    }

    @Generated
    public DataSourceController(DataSourceService datasourceService) {
        this.datasourceService = datasourceService;
    }
}

