/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.config.template;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.config.template.TemplateInfo;
import org.springframework.util.StreamUtils;

public class GeneratorConfig {
    private static final String PROJECT = "project";
    private static final String TEMPLATES = "templates";
    private static final String SUB_TEMPLATES = "subTemplates";
    private String template;

    public GeneratorConfig(String template) {
        this.template = template;
    }

    public List<TemplateInfo> getTemplateConfig(Map<String, Object> dataModel) {
        try {
            List tableOperation = (List)dataModel.get("tableOperation");
            List<TemplateInfo> templates = this.getConfigJson().getBeanList((Object)TEMPLATES, TemplateInfo.class);
            if (!ArrayUtil.containsAny((Object[])tableOperation.toArray(), (Object[])new Object[]{"export", "import"})) {
                templates = templates.stream().filter(t -> !StrUtil.contains((CharSequence)t.getTemplateName(), (CharSequence)"Excel.java")).toList();
            }
            if (ObjUtil.equal((Object)dataModel.get("hasLeftFormDs"), (Object)true)) {
                templates = templates.stream().filter(t -> !StrUtil.contains((CharSequence)t.getTemplateName(), (CharSequence)"Dao.xml")).toList();
            }
            this.getTemplateContent(templates);
            return templates;
        }
        catch (IOException e) {
            throw new ServerException("\u8bfb\u53d6config.json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
    }

    public List<TemplateInfo> getSubTemplateConfig() {
        try {
            List templates = this.getConfigJson().getBeanList((Object)SUB_TEMPLATES, TemplateInfo.class);
            this.getTemplateContent(templates);
            return templates;
        }
        catch (IOException e) {
            throw new ServerException("\u8bfb\u53d6config.json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
    }

    private JSONObject getConfigJson() {
        InputStream isConfig = this.getClass().getResourceAsStream(this.getTemplatePath() + "config.json");
        if (isConfig == null) {
            throw new ServerException("\u9879\u76ee\u914d\u7f6e\u6587\u4ef6\uff0cconfig.json\u4e0d\u5b58\u5728");
        }
        try {
            String configContent = StreamUtils.copyToString((InputStream)isConfig, (Charset)StandardCharsets.UTF_8);
            return JSONUtil.parseObj((String)configContent);
        }
        catch (IOException e) {
            throw new ServerException("config.json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
    }

    private void getTemplateContent(List<TemplateInfo> templates) throws IOException {
        for (TemplateInfo templateInfo : templates) {
            InputStream isTemplate = this.getClass().getResourceAsStream(this.template + templateInfo.getTemplateName());
            if (isTemplate == null) {
                throw new ServerException("\u6a21\u677f\u6587\u4ef6 " + templateInfo.getTemplateName() + " \u4e0d\u5b58\u5728");
            }
            String templateContent = StreamUtils.copyToString((InputStream)isTemplate, (Charset)StandardCharsets.UTF_8);
            templateInfo.setTemplateContent(templateContent);
        }
    }

    public String getTemplateContent(String templateName) {
        try {
            InputStream isTemplate = this.getClass().getResourceAsStream(this.template + templateName);
            if (isTemplate == null) {
                throw new ServerException("\u6a21\u677f\u6587\u4ef6 " + templateName + " \u4e0d\u5b58\u5728");
            }
            return StreamUtils.copyToString((InputStream)isTemplate, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new ServerException("\u8bfb\u53d6\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u540d\uff1a" + templateName);
        }
    }

    private String getTemplatePath() {
        if (!StrUtil.endWith((CharSequence)this.template, (char)'/')) {
            this.template = this.template + "/";
        }
        return this.template;
    }
}

