/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.config;

import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import net.maku.generator.config.DbType;
import net.maku.generator.config.query.AbstractQuery;
import net.maku.generator.config.query.ClickHouseQuery;
import net.maku.generator.config.query.DmQuery;
import net.maku.generator.config.query.KingBaseSqlQuery;
import net.maku.generator.config.query.MySqlQuery;
import net.maku.generator.config.query.OracleQuery;
import net.maku.generator.config.query.PostgreSqlQuery;
import net.maku.generator.config.query.SQLServerQuery;
import net.maku.generator.entity.DataSourceEntity;
import net.maku.generator.utils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenDataSource.class);
    private Long id;
    private DbType dbType;
    private String connUrl;
    private String username;
    private String password;
    private AbstractQuery dbQuery;
    private Connection connection;

    public GenDataSource(DataSourceEntity entity) {
        this.id = entity.getId();
        this.dbType = DbType.getValue(entity.getDbType());
        this.connUrl = entity.getConnUrl();
        this.username = entity.getUsername();
        this.password = entity.getPassword();
        if (this.dbType == DbType.MySQL) {
            this.dbQuery = new MySqlQuery();
        } else if (this.dbType == DbType.Oracle) {
            this.dbQuery = new OracleQuery();
        } else if (this.dbType == DbType.PostgreSQL) {
            this.dbQuery = new PostgreSqlQuery();
        } else if (this.dbType == DbType.SQLServer) {
            this.dbQuery = new SQLServerQuery();
        } else if (this.dbType == DbType.DM) {
            this.dbQuery = new DmQuery();
        } else if (this.dbType == DbType.Clickhouse) {
            this.dbQuery = new ClickHouseQuery();
        } else if (this.dbType == DbType.KingBase) {
            this.dbQuery = new KingBaseSqlQuery();
        }
        try {
            this.connection = DbUtils.getConnection(this);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public GenDataSource(Connection connection) throws SQLException {
        this.id = 0L;
        this.dbType = DbType.getValue(connection.getMetaData().getDatabaseProductName());
        if (this.dbType == DbType.MySQL) {
            this.dbQuery = new MySqlQuery();
        } else if (this.dbType == DbType.Oracle) {
            this.dbQuery = new OracleQuery();
        } else if (this.dbType == DbType.PostgreSQL) {
            this.dbQuery = new PostgreSqlQuery();
        } else if (this.dbType == DbType.SQLServer) {
            this.dbQuery = new SQLServerQuery();
        } else if (this.dbType == DbType.DM) {
            this.dbQuery = new DmQuery();
        } else if (this.dbType == DbType.Clickhouse) {
            this.dbQuery = new ClickHouseQuery();
        } else if (this.dbType == DbType.KingBase) {
            this.dbQuery = new KingBaseSqlQuery();
        }
        this.connection = connection;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public DbType getDbType() {
        return this.dbType;
    }

    @Generated
    public String getConnUrl() {
        return this.connUrl;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public AbstractQuery getDbQuery() {
        return this.dbQuery;
    }

    @Generated
    public Connection getConnection() {
        return this.connection;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    @Generated
    public void setConnUrl(String connUrl) {
        this.connUrl = connUrl;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDbQuery(AbstractQuery dbQuery) {
        this.dbQuery = dbQuery;
    }

    @Generated
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenDataSource)) {
            return false;
        }
        GenDataSource other = (GenDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !((Object)((Object)this$dbType)).equals((Object)other$dbType)) {
            return false;
        }
        String this$connUrl = this.getConnUrl();
        String other$connUrl = other.getConnUrl();
        if (this$connUrl == null ? other$connUrl != null : !this$connUrl.equals(other$connUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        AbstractQuery this$dbQuery = this.getDbQuery();
        AbstractQuery other$dbQuery = other.getDbQuery();
        if (this$dbQuery == null ? other$dbQuery != null : !this$dbQuery.equals(other$dbQuery)) {
            return false;
        }
        Connection this$connection = this.getConnection();
        Connection other$connection = other.getConnection();
        return !(this$connection == null ? other$connection != null : !this$connection.equals(other$connection));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenDataSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : ((Object)((Object)$dbType)).hashCode());
        String $connUrl = this.getConnUrl();
        result = result * 59 + ($connUrl == null ? 43 : $connUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        AbstractQuery $dbQuery = this.getDbQuery();
        result = result * 59 + ($dbQuery == null ? 43 : $dbQuery.hashCode());
        Connection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GenDataSource(id=" + this.getId() + ", dbType=" + this.getDbType() + ", connUrl=" + this.getConnUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbQuery=" + this.getDbQuery() + ", connection=" + this.getConnection() + ")";
    }
}

