/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.common.utils;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(text, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(text, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (StrUtil.isBlank((CharSequence)text)) {
            return new ArrayList();
        }
        try {
            return (List)objectMapper.readValue(text, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

