/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.common.aspect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.maku.generator.common.annotation.EncryptParameter;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.utils.EncryptUtils;
import net.maku.generator.common.utils.Result;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EncryptParameterAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptParameterAspect.class);

    @Around(value="execution(* net.maku.generator.controller.DataSourceController.*(..))")
    public Object doProcess(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        List<Object> methodArgs = this.getMethodArgs(proceedingJoinPoint);
        for (Object item : methodArgs) {
            this.handleItem(item, true);
        }
        Object result = proceedingJoinPoint.proceed();
        this.handleObject(result);
        return result;
    }

    private List<Object> getMethodArgs(ProceedingJoinPoint proceedingJoinPoint) {
        ArrayList<Object> methodArgs = new ArrayList<Object>();
        for (Object arg : proceedingJoinPoint.getArgs()) {
            if (!Objects.nonNull(arg)) continue;
            methodArgs.add(arg);
        }
        return methodArgs;
    }

    private void handleObject(Object object) throws Exception {
        if (!(object instanceof Result) || Objects.isNull(((Result)object).getData())) {
            return;
        }
        Object data = ((Result)object).getData();
        if (data instanceof List || data instanceof PageResult) {
            List<Object> itemList = data instanceof List ? (List<Object>)data : ((PageResult)data).getList();
            itemList.forEach(f -> this.handleItem(f, false));
        } else {
            this.handleItem(data, false);
        }
    }

    private void handleItem(Object item, boolean isDecrypt) {
        Field[] fields;
        if (Objects.isNull(item.getClass().getPackage()) || !item.getClass().getPackage().getName().startsWith("net.maku.generator.entity")) {
            return;
        }
        for (Field field : fields = item.getClass().getDeclaredFields()) {
            Class<?> fieldType = field.getType();
            if (fieldType != String.class || !Objects.nonNull(AnnotationUtils.findAnnotation((AnnotatedElement)field, EncryptParameter.class))) continue;
            field.setAccessible(Boolean.TRUE);
            try {
                String newFieldValue = isDecrypt ? EncryptUtils.decrypt((String)field.get(item)) : EncryptUtils.encrypt((String)field.get(item));
                field.set(item, newFieldValue);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            field.setAccessible(Boolean.FALSE);
        }
    }
}

