/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.ratelimiter;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.dreamlu.mica.redis.ratelimiter.RateLimiterClient;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisRateLimiterClient
implements RateLimiterClient {
    private static final String REDIS_KEY_PREFIX = "limiter:";
    private static final long FAIL_CODE = 0L;
    private final StringRedisTemplate redisTemplate;
    private final RedisScript<Long> script;
    private final Environment environment;

    @Override
    public boolean isAllowed(String key, long max, long ttl, TimeUnit timeUnit) {
        String redisKeyBuilder = REDIS_KEY_PREFIX + RedisRateLimiterClient.getApplicationName(this.environment) + ":" + key;
        List<CallSite> keys = Collections.singletonList(redisKeyBuilder);
        long ttlMillis = timeUnit.toMillis(ttl);
        Long result = (Long)this.redisTemplate.execute(this.script, keys, new Object[]{Long.toString(max), Long.toString(ttlMillis)});
        return result != null && result != 0L;
    }

    private static String getApplicationName(Environment environment) {
        return environment.getProperty("spring.application.name", "");
    }

    @Generated
    public RedisRateLimiterClient(StringRedisTemplate redisTemplate, RedisScript<Long> script, Environment environment) {
        this.redisTemplate = redisTemplate;
        this.script = script;
        this.environment = environment;
    }
}

