/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.pubsub;

import java.lang.reflect.Method;
import lombok.Generated;
import net.dreamlu.mica.core.utils.ReflectUtil;
import net.dreamlu.mica.redis.pubsub.ChannelUtil;
import net.dreamlu.mica.redis.pubsub.RPubSubEvent;
import net.dreamlu.mica.redis.pubsub.RPubSubListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class RPubSubListenerDetector
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPubSubListenerDetector.class);
    private final RedisMessageListenerContainer redisMessageListenerContainer;
    private final RedisSerializer<Object> redisSerializer;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class userClass = ClassUtils.getUserClass((Object)bean);
        ReflectionUtils.doWithMethods((Class)userClass, method -> {
            RPubSubListener listener = (RPubSubListener)AnnotationUtils.findAnnotation((Method)method, RPubSubListener.class);
            if (listener != null) {
                String channel = listener.value();
                Assert.hasText((String)channel, (String)"@RPubSubListener value channel must not be empty.");
                log.info("Found @RPubSubListener on bean:{} method:{}", (Object)beanName, (Object)method);
                int paramCount = method.getParameterCount();
                if (paramCount > 1) {
                    throw new IllegalArgumentException("@RPubSubListener on method " + method + " parameter count must less or equal to 1.");
                }
                Topic topic = ChannelUtil.getTopic(channel);
                this.redisMessageListenerContainer.addMessageListener((message, pattern) -> {
                    String messageChannel = new String(message.getChannel());
                    Object body = this.redisSerializer.deserialize(message.getBody());
                    RPubSubListenerDetector.invokeMethod(bean, method, paramCount, new RPubSubEvent<Object>(channel, messageChannel, body));
                }, topic);
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return bean;
    }

    private static void invokeMethod(Object bean, Method method, int paramCount, RPubSubEvent<Object> topicEvent) {
        if (paramCount == 0) {
            ReflectUtil.invokeMethod((Method)method, (Object)bean);
        } else {
            ReflectUtil.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{topicEvent});
        }
    }

    @Generated
    public RPubSubListenerDetector(RedisMessageListenerContainer redisMessageListenerContainer, RedisSerializer<Object> redisSerializer) {
        this.redisMessageListenerContainer = redisMessageListenerContainer;
        this.redisSerializer = redisSerializer;
    }
}

