/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.config;

import net.dreamlu.mica.redis.cache.MicaRedisCache;
import net.dreamlu.mica.redis.config.RedisTemplateConfiguration;
import net.dreamlu.mica.redis.pubsub.RPubSubListenerDetector;
import net.dreamlu.mica.redis.pubsub.RPubSubListenerLazyFilter;
import net.dreamlu.mica.redis.pubsub.RPubSubPublisher;
import net.dreamlu.mica.redis.pubsub.RedisPubSubPublisher;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;

@AutoConfiguration(after={RedisTemplateConfiguration.class})
public class RedisPubSubConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    public RPubSubPublisher topicEventPublisher(MicaRedisCache redisCache, RedisSerializer<Object> redisSerializer) {
        return new RedisPubSubPublisher(redisCache, redisSerializer);
    }

    @Bean
    @ConditionalOnBean(value={RedisSerializer.class})
    public RPubSubListenerDetector topicListenerDetector(RedisMessageListenerContainer redisMessageListenerContainer, RedisSerializer<Object> redisSerializer) {
        return new RPubSubListenerDetector(redisMessageListenerContainer, redisSerializer);
    }

    @Bean
    public RPubSubListenerLazyFilter pubSubListenerLazyFilter() {
        return new RPubSubListenerLazyFilter();
    }
}

