/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.cache;

import java.time.Duration;
import javax.annotation.Nullable;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.redis.cache.CacheKey;
import org.springframework.util.ObjectUtils;

public interface ICacheKey {
    public String getPrefix();

    @Nullable
    default public Duration getExpire() {
        return null;
    }

    default public String getKeyStr(Object ... suffix) {
        String prefix = this.getPrefix();
        if (ObjectUtils.isEmpty((Object[])suffix)) {
            return prefix;
        }
        return prefix.concat(StringUtil.join((Object[])suffix, (String)":"));
    }

    default public CacheKey getKey(Object ... suffix) {
        String key = this.getKeyStr(suffix);
        Duration expire = this.getExpire();
        return expire == null ? new CacheKey(key) : new CacheKey(key, expire);
    }
}

