/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.redis.cache;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.redis.cache.CacheKey;
import net.dreamlu.mica.redis.cache.RedisCommand;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

public class MicaRedisCache {
    private final RedisTemplate<String, Object> redisTemplate;
    private final ValueOperations<String, Object> valueOps;
    private final HashOperations<String, Object, Object> hashOps;
    private final ListOperations<String, Object> listOps;
    private final SetOperations<String, Object> setOps;
    private final ZSetOperations<String, Object> zSetOps;

    public MicaRedisCache(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
        this.valueOps = redisTemplate.opsForValue();
        this.hashOps = redisTemplate.opsForHash();
        this.listOps = redisTemplate.opsForList();
        this.setOps = redisTemplate.opsForSet();
        this.zSetOps = redisTemplate.opsForZSet();
    }

    public static MicaRedisCache use(RedisTemplate<String, Object> redisTemplate) {
        return new MicaRedisCache(redisTemplate);
    }

    public <T> void set(CacheKey cacheKey, T value) {
        String key = cacheKey.getKey();
        Duration expire = cacheKey.getExpire();
        if (expire == null) {
            this.set(key, value);
        } else {
            this.setEx(key, value, expire);
        }
    }

    public <T> void set(String key, T value) {
        this.valueOps.set((Object)key, value);
    }

    public <T> void set(String key, T value, Function<T, byte[]> mapper) {
        this.redisTemplate.execute(redis -> redis.set(MicaRedisCache.keySerialize(key), (byte[])mapper.apply(value)));
    }

    public <T> void setEx(String key, T value, Duration timeout) {
        this.valueOps.set((Object)key, value, timeout);
    }

    public <T> void setEx(String key, T value, Long seconds) {
        this.valueOps.set((Object)key, value, seconds.longValue(), TimeUnit.SECONDS);
    }

    public <T> void setEx(String key, T value, long timeout, TimeUnit unit) {
        this.valueOps.set((Object)key, value, timeout, unit);
    }

    @Nullable
    public <T> Boolean setNx(String key, T value) {
        return this.valueOps.setIfAbsent((Object)key, value);
    }

    @Nullable
    public <T> Boolean setNx(String key, T value, long time, TimeUnit unit) {
        return this.valueOps.setIfAbsent((Object)key, value, time, unit);
    }

    @Nullable
    public <T> T get(String key) {
        return (T)this.valueOps.get((Object)key);
    }

    @Nullable
    public <T> T get(String key, Function<byte[], T> mapper) {
        return (T)this.redisTemplate.execute(redis -> {
            byte[] value = redis.get(MicaRedisCache.keySerialize(key));
            if (value == null) {
                return null;
            }
            return mapper.apply(value);
        });
    }

    @Nullable
    public <T> T getByJdkSer(String key) {
        return (T)this.get(key, (byte[] value) -> RedisSerializer.java().deserialize(value));
    }

    @Nullable
    public <T> T getByJsonSer(String key, Class<T> clazz) {
        return (T)this.get(key, (byte[] value) -> JsonUtil.readValue((byte[])value, (Class)clazz));
    }

    @Nullable
    public <T> T get(String key, Supplier<T> loader) {
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            return null;
        }
        this.set(key, value);
        return value;
    }

    @Nullable
    public <T> T getByJsonSer(String key, Class<T> clazz, Supplier<T> loader) {
        T value = this.getByJsonSer(key, clazz);
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            return null;
        }
        this.set(key, value);
        return value;
    }

    @Nullable
    public <T> T get(CacheKey cacheKey) {
        return (T)this.valueOps.get((Object)cacheKey.getKey());
    }

    @Nullable
    public <T> T getByJsonSer(CacheKey cacheKey, Class<T> clazz) {
        return this.getByJsonSer(cacheKey.getKey(), clazz);
    }

    @Nullable
    public <T> T get(CacheKey cacheKey, Supplier<T> loader) {
        String key = cacheKey.getKey();
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            return null;
        }
        this.set(cacheKey, value);
        return value;
    }

    @Nullable
    public <T> T getByJsonSer(CacheKey cacheKey, Class<T> clazz, Supplier<T> loader) {
        String key = cacheKey.getKey();
        T value = this.getByJsonSer(key, clazz);
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            return null;
        }
        this.set(cacheKey, value);
        return value;
    }

    @Nullable
    public Boolean del(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    @Nullable
    public Boolean del(CacheKey key) {
        return this.redisTemplate.delete((Object)key.getKey());
    }

    @Nullable
    public Long del(String ... keys) {
        return this.del(Arrays.asList(keys));
    }

    @Nullable
    public Long del(Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    @Nullable
    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Set<String> scan(String pattern) {
        return this.scan(pattern, 100L);
    }

    public Set<String> scan(String pattern, @Nullable Long count) {
        HashSet<String> keySet = new HashSet<String>();
        this.scan(pattern, count, keySet::add);
        return keySet;
    }

    public void scan(String pattern, Consumer<String> consumer) {
        this.scan(pattern, 100L, consumer);
    }

    public void scan(String pattern, @Nullable Long count, Consumer<String> consumer) {
        this.scanBytes(pattern, count, bytes -> consumer.accept(MicaRedisCache.keyDeserialize(bytes)));
    }

    public void scanBytes(String pattern, @Nullable Long count, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(redis -> {
            ScanOptions.ScanOptionsBuilder builder = ScanOptions.scanOptions().match(pattern);
            if (count != null) {
                builder.count(count.longValue());
            }
            try (Cursor cursor = redis.scan(builder.build());){
                cursor.forEachRemaining(consumer);
            }
            return null;
        });
    }

    public Set<String> sScan(String key, String pattern) {
        return this.sScan(key, pattern, 100L);
    }

    public Set<String> sScan(String key, String pattern, @Nullable Long count) {
        HashSet<String> keySet = new HashSet<String>();
        this.sScan(key, pattern, count, keySet::add);
        return keySet;
    }

    public void sScan(String key, String pattern, Consumer<String> consumer) {
        this.sScan(key, pattern, 100L, consumer);
    }

    public void sScan(String key, String pattern, @Nullable Long count, Consumer<String> consumer) {
        this.sScanBytes(key, pattern, count, bytes -> consumer.accept(MicaRedisCache.keyDeserialize(bytes)));
    }

    public void sScanBytes(String key, String pattern, @Nullable Long count, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(redis -> {
            ScanOptions.ScanOptionsBuilder builder = ScanOptions.scanOptions().match(pattern);
            if (count != null) {
                builder.count(count.longValue());
            }
            try (Cursor cursor = redis.sScan(MicaRedisCache.keySerialize(key), builder.build());){
                cursor.forEachRemaining(consumer);
            }
            return null;
        });
    }

    @Nullable
    public Long sCard(String key) {
        return this.setOps.size((Object)key);
    }

    public void mSet(Object ... keysValues) {
        this.valueOps.multiSet(CollectionUtil.toMap((Object[])keysValues));
    }

    @Nullable
    public List<Object> mGet(String ... keys) {
        return this.mGet(Arrays.asList(keys));
    }

    @Nullable
    public List<Object> mGet(Collection<String> keys) {
        return this.valueOps.multiGet(keys);
    }

    @Nullable
    public Long decr(String key) {
        return this.valueOps.decrement((Object)key);
    }

    @Nullable
    public Long decrBy(String key, long longValue) {
        return this.valueOps.decrement((Object)key, longValue);
    }

    public Long decrBy(String key, long longValue, long seconds) {
        byte[] serializedKey = MicaRedisCache.keySerialize(key);
        List result = this.redisTemplate.executePipelined(redis -> {
            Long data = redis.decrBy(serializedKey, longValue);
            redis.expire(serializedKey, seconds);
            return data;
        });
        return (Long)result.get(0);
    }

    public Long decrBy(String key, long longValue, Duration timeout) {
        long seconds = timeout.getSeconds();
        return this.decrBy(key, longValue, seconds);
    }

    @Nullable
    public Long incr(String key) {
        return this.valueOps.increment((Object)key);
    }

    @Nullable
    public Long incrBy(String key, long longValue) {
        return this.valueOps.increment((Object)key, longValue);
    }

    public Long incrBy(String key, long longValue, long seconds) {
        byte[] serializedKey = MicaRedisCache.keySerialize(key);
        List result = this.redisTemplate.executePipelined(redis -> {
            Long data = redis.incrBy(serializedKey, longValue);
            redis.expire(serializedKey, seconds);
            return data;
        });
        return (Long)result.get(0);
    }

    public Long incrBy(String key, long longValue, Duration timeout) {
        long seconds = timeout.getSeconds();
        return this.incrBy(key, longValue, seconds);
    }

    @Nullable
    public Long getCounter(String key) {
        return (Long)this.redisTemplate.execute(redis -> {
            byte[] value = redis.get(MicaRedisCache.keySerialize(key));
            if (value == null) {
                return null;
            }
            return Long.valueOf(new String(value, StandardCharsets.UTF_8));
        });
    }

    @Nullable
    public Long getCounter(String key, long seconds, Supplier<Long> loader) {
        return (Long)this.redisTemplate.execute(redis -> {
            long longValue;
            byte[] keyBytes = MicaRedisCache.keySerialize(key);
            byte[] value = redis.get(keyBytes);
            if (value != null) {
                longValue = Long.parseLong(new String(value, StandardCharsets.UTF_8));
            } else {
                Long loaderValue = (Long)loader.get();
                longValue = loaderValue == null ? 0L : loaderValue;
                redis.setEx(keyBytes, seconds, String.valueOf(longValue).getBytes());
            }
            return longValue;
        });
    }

    @Nullable
    public Boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Nullable
    public Boolean exists(CacheKey cacheKey) {
        return this.exists(cacheKey.getKey());
    }

    @Nullable
    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(String oldkey, String newkey) {
        this.redisTemplate.rename((Object)oldkey, (Object)newkey);
    }

    @Nullable
    public Boolean move(String key, int dbIndex) {
        return this.redisTemplate.move((Object)key, dbIndex);
    }

    @Nullable
    public Boolean expire(String key, long seconds) {
        return this.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
    }

    @Nullable
    public Boolean expire(String key, Duration timeout) {
        return this.expire(key, timeout.getSeconds());
    }

    @Nullable
    public Boolean expireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    @Nullable
    public Boolean expireAt(String key, long unixTime) {
        return this.expireAt(key, new Date(unixTime));
    }

    @Nullable
    public Boolean pExpire(String key, long milliseconds) {
        return this.redisTemplate.expire((Object)key, milliseconds, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public <T> T getSet(String key, T value) {
        return (T)this.valueOps.getAndSet((Object)key, value);
    }

    @Nullable
    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public String type(String key) {
        return this.redisTemplate.type((Object)key).code();
    }

    @Nullable
    public Long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    @Nullable
    public Long pttl(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    public <F, V> void hSet(String key, F field, V value) {
        this.hashOps.put((Object)key, field, value);
    }

    public <F, V> void hMset(String key, Map<F, V> hash) {
        this.hashOps.putAll((Object)key, hash);
    }

    @Nullable
    public <T> T hGet(String key, Object field) {
        return (T)this.hashOps.get((Object)key, field);
    }

    public <F, V> List<V> hmGet(String key, F ... fields) {
        return this.hmGet(key, (Collection<F>)Arrays.asList(fields));
    }

    public <F, V> List<V> hmGet(String key, Collection<F> hashKeys) {
        return this.hashOps.multiGet((Object)key, hashKeys);
    }

    public Long hDel(String key, Object ... fields) {
        return this.hashOps.delete((Object)key, fields);
    }

    public Boolean hExists(String key, Object field) {
        return this.hashOps.hasKey((Object)key, field);
    }

    public Map hGetAll(String key) {
        return this.hashOps.entries((Object)key);
    }

    public List hVals(String key) {
        return this.hashOps.values((Object)key);
    }

    public Set<Object> hKeys(String key) {
        return this.hashOps.keys((Object)key);
    }

    public Long hLen(String key) {
        return this.hashOps.size((Object)key);
    }

    public Long hIncrBy(String key, Object field, long value) {
        return this.hashOps.increment((Object)key, field, value);
    }

    public Double hIncrByFloat(String key, Object field, double value) {
        return this.hashOps.increment((Object)key, field, value);
    }

    @Nullable
    public <T> T lIndex(String key, long index) {
        return (T)this.listOps.index((Object)key, index);
    }

    @Nullable
    public Long lLen(String key) {
        return this.listOps.size((Object)key);
    }

    @Nullable
    public <T> T lPop(String key) {
        return (T)this.listOps.leftPop((Object)key);
    }

    @Nullable
    public <T> Long lPush(String key, T value) {
        return this.listOps.leftPush((Object)key, value);
    }

    @Nullable
    public <T> Long lPush(String key, T ... values) {
        return this.listOps.leftPushAll((Object)key, (Object[])values);
    }

    @Nullable
    public <T> Long lPush(String key, Collection<T> values) {
        return this.listOps.leftPushAll((Object)key, new Object[]{values});
    }

    public void lSet(String key, long index, Object value) {
        this.listOps.set((Object)key, index, value);
    }

    @Nullable
    public Long lRem(String key, long count, Object value) {
        return this.listOps.remove((Object)key, count, value);
    }

    @Nullable
    public <T> List<T> lRange(String key, long start, long end) {
        return this.listOps.range((Object)key, start, end);
    }

    public void lTrim(String key, long start, long end) {
        this.listOps.trim((Object)key, start, end);
    }

    @Nullable
    public <T> T rPop(String key) {
        return (T)this.listOps.rightPop((Object)key);
    }

    @Nullable
    public <T> Long rPush(String key, T value) {
        return this.listOps.rightPush((Object)key, value);
    }

    @Nullable
    public <T> Long rPush(String key, T ... values) {
        return this.listOps.rightPushAll((Object)key, (Object[])values);
    }

    @Nullable
    public <T> Long rPush(String key, Collection<T> values) {
        return this.listOps.rightPushAll((Object)key, new Object[]{values});
    }

    @Nullable
    public <T> T rPopLPush(String srcKey, String dstKey) {
        return (T)this.listOps.rightPopAndLeftPush((Object)srcKey, (Object)dstKey);
    }

    @Nullable
    public <T> Long sAdd(String key, T ... members) {
        return this.setOps.add((Object)key, (Object[])members);
    }

    @Nullable
    public <T> T sPop(String key) {
        return (T)this.setOps.pop((Object)key);
    }

    @Nullable
    public <T> Set<T> sMembers(String key) {
        return this.setOps.members((Object)key);
    }

    @Nullable
    public <T> Boolean sIsMember(String key, T member) {
        return this.setOps.isMember((Object)key, member);
    }

    @Nullable
    public <T> Set<T> sInter(String key, String otherKey) {
        return this.setOps.intersect((Object)key, (Object)otherKey);
    }

    @Nullable
    public <T> Set<T> sInter(String key, Collection<String> otherKeys) {
        return this.setOps.intersect((Object)key, otherKeys);
    }

    public <T> T sRandMember(String key) {
        return (T)this.setOps.randomMember((Object)key);
    }

    @Nullable
    public <T> List<T> sRandMember(String key, int count) {
        return this.setOps.randomMembers((Object)key, (long)count);
    }

    @Nullable
    public <T> Long sRem(String key, T ... members) {
        return this.setOps.remove((Object)key, (Object[])members);
    }

    @Nullable
    public <T> Set<T> sUnion(String key, String otherKey) {
        return this.setOps.union((Object)key, (Object)otherKey);
    }

    @Nullable
    public <T> Set<T> sUnion(String key, Collection<String> otherKeys) {
        return this.setOps.union((Object)key, otherKeys);
    }

    @Nullable
    public <T> Set<T> sUnion(Collection<String> keys) {
        return this.setOps.union(keys);
    }

    @Nullable
    public <T> Set<T> sDiff(String key, String otherKey) {
        return this.setOps.difference((Object)key, (Object)otherKey);
    }

    @Nullable
    public <T> Set<T> sDiff(String key, Collection<String> otherKeys) {
        return this.setOps.difference((Object)key, otherKeys);
    }

    @Nullable
    public <T> Boolean zAdd(String key, T member, double score) {
        return this.zSetOps.add((Object)key, member, score);
    }

    @Nullable
    public <T> Long zAdd(String key, Map<T, Double> scoreMembers) {
        HashSet tuples = new HashSet();
        scoreMembers.forEach((k, v) -> tuples.add(new DefaultTypedTuple(k, v)));
        return this.zSetOps.add((Object)key, tuples);
    }

    @Nullable
    public Long zCard(String key) {
        return this.zSetOps.zCard((Object)key);
    }

    @Nullable
    public Long zCount(String key, double min, double max) {
        return this.zSetOps.count((Object)key, min, max);
    }

    @Nullable
    public <T> Double zIncrBy(String key, T member, double score) {
        return this.zSetOps.incrementScore((Object)key, member, score);
    }

    @Nullable
    public <T> Set<T> zRange(String key, long start, long end) {
        return this.zSetOps.range((Object)key, start, end);
    }

    @Nullable
    public <T> Set<T> zRevrange(String key, long start, long end) {
        return this.zSetOps.reverseRange((Object)key, start, end);
    }

    @Nullable
    public <T> Set<T> zRangeByScore(String key, double min, double max) {
        return this.zSetOps.rangeByScore((Object)key, min, max);
    }

    @Nullable
    public <T> Long zRank(String key, T member) {
        return this.zSetOps.rank((Object)key, member);
    }

    @Nullable
    public <T> Long zRevrank(String key, T member) {
        return this.zSetOps.reverseRank((Object)key, member);
    }

    @Nullable
    public <T> Long zRem(String key, T ... members) {
        return this.zSetOps.remove((Object)key, (Object[])members);
    }

    @Nullable
    public <T> Double zScore(String key, T member) {
        return this.zSetOps.score((Object)key, member);
    }

    @Nullable
    public <T> Long publish(String channel, T message, Function<T, byte[]> mapper) {
        return (Long)this.redisTemplate.execute(redis -> {
            byte[] channelBytes = MicaRedisCache.keySerialize(channel);
            return redis.publish(channelBytes, (byte[])mapper.apply(message));
        });
    }

    @Nullable
    public void subscribe(String channel, MessageListener listener) {
        this.redisTemplate.execute(redis -> {
            byte[] channelBytes = MicaRedisCache.keySerialize(channel);
            redis.subscribe(listener, (byte[][])new byte[][]{channelBytes});
            return null;
        });
    }

    @Nullable
    public void pSubscribe(String pattern, MessageListener listener) {
        this.redisTemplate.execute(redis -> {
            byte[] patternBytes = MicaRedisCache.keySerialize(pattern);
            redis.pSubscribe(listener, (byte[][])new byte[][]{patternBytes});
            return null;
        });
    }

    @Nullable
    public Long bitCount(String key) {
        return (Long)this.redisTemplate.execute(redis -> redis.bitCount(MicaRedisCache.keySerialize(key)));
    }

    @Nullable
    public Long bitCount(String key, long start, long end) {
        return (Long)this.redisTemplate.execute(redis -> redis.bitCount(MicaRedisCache.keySerialize(key), start, end));
    }

    @Nullable
    public Long bitCount(String key, long start, long end, RedisCommand.BitMapModel model) {
        return (Long)this.redisTemplate.execute(redis -> (Long)redis.execute("BITCOUNT", (byte[][])new byte[][]{MicaRedisCache.keySerialize(key), MicaRedisCache.keySerialize(Long.toString(start)), MicaRedisCache.keySerialize(Long.toString(end)), MicaRedisCache.keySerialize(model.name())}));
    }

    @Nullable
    public List<Long> bitField(String key, BitFieldSubCommands commands) {
        return (List)this.redisTemplate.execute(redis -> redis.bitField(MicaRedisCache.keySerialize(key), commands));
    }

    @Nullable
    public Long bitPos(String key, boolean bit) {
        return (Long)this.redisTemplate.execute(redis -> redis.bitPos(MicaRedisCache.keySerialize(key), bit));
    }

    @Nullable
    public Long bitPos(String key, boolean bit, Range<Long> range) {
        return (Long)this.redisTemplate.execute(redis -> redis.bitPos(MicaRedisCache.keySerialize(key), bit, range));
    }

    @Nullable
    public Boolean getBit(String key, long offset) {
        return (Boolean)this.redisTemplate.execute(redis -> redis.getBit(MicaRedisCache.keySerialize(key), offset));
    }

    @Nullable
    public Boolean setBit(String key, long offset, boolean value) {
        return (Boolean)this.redisTemplate.execute(redis -> redis.setBit(MicaRedisCache.keySerialize(key), offset, value));
    }

    public static byte[] keySerialize(String redisKey) {
        return Objects.requireNonNull(RedisSerializer.string().serialize((Object)redisKey), "Redis key is null.");
    }

    public static String keyDeserialize(byte[] redisKey) {
        return (String)Objects.requireNonNull(RedisSerializer.string().deserialize(redisKey), "Redis key is null.");
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public ValueOperations<String, Object> getValueOps() {
        return this.valueOps;
    }

    public HashOperations<String, Object, Object> getHashOps() {
        return this.hashOps;
    }

    public ListOperations<String, Object> getListOps() {
        return this.listOps;
    }

    public SetOperations<String, Object> getSetOps() {
        return this.setOps;
    }

    public ZSetOperations<String, Object> getZSetOps() {
        return this.zSetOps;
    }
}

