/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class ThreadLocalUtil {
    private static final ThreadLocal<Map<String, Object>> LOCAL = ThreadLocal.withInitial(HashMap::new);

    public static Map<String, Object> getAll() {
        return new HashMap<String, Object>(LOCAL.get());
    }

    public static <T> T put(String key, T value) {
        LOCAL.get().put(key, value);
        return value;
    }

    public static void put(Map<String, Object> map) {
        LOCAL.get().putAll(map);
    }

    public static void remove(String key) {
        LOCAL.get().remove(key);
    }

    public static void clear() {
        LOCAL.remove();
    }

    public static <T> @Nullable T get(String key) {
        return (T)LOCAL.get().get(key);
    }

    public static <T> @Nullable T getIfAbsent(String key, Supplier<T> supplierOnNull) {
        return (T)LOCAL.get().computeIfAbsent(key, k -> supplierOnNull.get());
    }

    public static <T> @Nullable T getAndRemove(String key) {
        try {
            T t = ThreadLocalUtil.get(key);
            return t;
        }
        finally {
            ThreadLocalUtil.remove(key);
        }
    }
}

