/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.util.ObjectUtils;

public class ObjectUtil
extends ObjectUtils {
    public static boolean isNull(@Nullable Object object) {
        return Objects.isNull(object);
    }

    public static boolean isNotNull(@Nullable Object object) {
        return Objects.nonNull(object);
    }

    public static boolean isTrue(@Nullable Boolean object) {
        return Boolean.TRUE.equals(object);
    }

    public static boolean isFalse(@Nullable Boolean object) {
        return object == null || Boolean.FALSE.equals(object);
    }

    public static boolean isNotEmpty(@Nullable Object[] array) {
        return !ObjectUtils.isEmpty((Object[])array);
    }

    public static boolean isNotEmpty(@Nullable Object obj) {
        return !ObjectUtils.isEmpty((Object)obj);
    }

    public static boolean equals(@Nullable Object o1, @Nullable Object o2) {
        return Objects.equals(o1, o2);
    }

    public static boolean isNotEqual(Object o1, Object o2) {
        return !Objects.equals(o1, o2);
    }

    public static int hashCode(@Nullable Object obj) {
        return Objects.hashCode(obj);
    }

    public static Object defaultIfNull(@Nullable Object object, Object defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static @Nullable String toStr(@Nullable Object object) {
        return ObjectUtil.toStr(object, null);
    }

    public static @Nullable String toStr(@Nullable Object object, @Nullable String defaultValue) {
        if (null == object) {
            return defaultValue;
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            return cs.toString();
        }
        return String.valueOf(object);
    }

    public static int toInt(@Nullable Object object) {
        return ObjectUtil.toInt(object, 0);
    }

    public static int toInt(@Nullable Object object, int defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.intValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static long toLong(@Nullable Object object) {
        return ObjectUtil.toLong(object, 0L);
    }

    public static long toLong(@Nullable Object object, long defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.longValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static float toFloat(@Nullable Object object) {
        return ObjectUtil.toFloat(object, 0.0f);
    }

    public static float toFloat(@Nullable Object object, float defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.floatValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static double toDouble(@Nullable Object object) {
        return ObjectUtil.toDouble(object, 0.0);
    }

    public static double toDouble(@Nullable Object object, double defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.doubleValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static byte toByte(@Nullable Object object) {
        return ObjectUtil.toByte(object, (byte)0);
    }

    public static byte toByte(@Nullable Object object, byte defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.byteValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Byte.parseByte(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static short toShort(@Nullable Object object) {
        return ObjectUtil.toShort(object, (short)0);
    }

    public static short toShort(@Nullable Object object, short defaultValue) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.byteValue();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            try {
                return Short.parseShort(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static @Nullable Boolean toBoolean(@Nullable Object object) {
        return ObjectUtil.toBoolean(object, null);
    }

    public static @Nullable Boolean toBoolean(@Nullable Object object, @Nullable Boolean defaultValue) {
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            String value = cs.toString();
            if ("true".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value) || "n".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "off".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
                return false;
            }
        }
        return defaultValue;
    }
}

