/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.Serializable;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class Lazy<T>
implements Supplier<T>,
Serializable {
    private transient @Nullable Supplier<? extends T> supplier;
    private @Nullable T value;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public @Nullable T get() {
        return this.supplier == null ? this.value : this.computeValue();
    }

    private synchronized @Nullable T computeValue() {
        Supplier<T> s = this.supplier;
        if (s != null) {
            this.value = s.get();
            this.supplier = null;
        }
        return this.value;
    }
}

