/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import net.dreamlu.mica.core.utils.DatePattern;
import org.jspecify.annotations.Nullable;

public class DateUtil {
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final DateTimeFormatter DATETIME_FORMATTER = DatePattern.NORM_DATETIME_FORMAT;
    public static final DateTimeFormatter DATE_FORMATTER = DatePattern.NORM_DATE_FORMAT;
    public static final DateTimeFormatter TIME_FORMATTER = DatePattern.NORM_TIME_FORMAT;
    private static final TemporalQuery<Instant> INSTANT_QUERY = new TemporalQuery<Instant>(){

        @Override
        public @Nullable Instant queryFrom(TemporalAccessor temporal) {
            if (temporal.isSupported(ChronoField.INSTANT_SECONDS) && temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
                long instantSecs = temporal.getLong(ChronoField.INSTANT_SECONDS);
                int nanoOfSecond = temporal.get(ChronoField.NANO_OF_SECOND);
                return Instant.ofEpochSecond(instantSecs, nanoOfSecond);
            }
            ZoneId zoneId = temporal.query(TemporalQueries.zoneId());
            Objects.requireNonNull(zoneId, "Unable to obtain Instant from TemporalAccessor: zoneId is null.");
            if (temporal.isSupported(ChronoField.NANO_OF_DAY)) {
                return LocalTime.ofNanoOfDay(temporal.getLong(ChronoField.NANO_OF_DAY)).atDate(EPOCH).atZone(zoneId).toInstant();
            }
            if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
                return LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY)).atStartOfDay().atZone(zoneId).toInstant();
            }
            return null;
        }

        public String toString() {
            return "Instant";
        }
    };
    public static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);

    public static Date plusYears(Date date, int yearsToAdd) {
        return DateUtil.plusAtUtc(date, Period.ofYears(yearsToAdd));
    }

    public static Date plusMonths(Date date, int monthsToAdd) {
        return DateUtil.plusAtUtc(date, Period.ofMonths(monthsToAdd));
    }

    public static Date plusWeeks(Date date, int weeksToAdd) {
        return DateUtil.plus(date, Period.ofWeeks(weeksToAdd));
    }

    public static Date plusDays(Date date, long daysToAdd) {
        return DateUtil.plus(date, Duration.ofDays(daysToAdd));
    }

    public static Date plusHours(Date date, long hoursToAdd) {
        return DateUtil.plus(date, Duration.ofHours(hoursToAdd));
    }

    public static Date plusMinutes(Date date, long minutesToAdd) {
        return DateUtil.plus(date, Duration.ofMinutes(minutesToAdd));
    }

    public static Date plusSeconds(Date date, long secondsToAdd) {
        return DateUtil.plus(date, Duration.ofSeconds(secondsToAdd));
    }

    public static Date plusMillis(Date date, long millisToAdd) {
        return DateUtil.plus(date, Duration.ofMillis(millisToAdd));
    }

    public static Date plusNanos(Date date, long nanosToAdd) {
        return DateUtil.plus(date, Duration.ofNanos(nanosToAdd));
    }

    public static Date plusAtUtc(Date date, TemporalAmount amount) {
        Instant instant = Objects.requireNonNull(date, "The date must not be null").toInstant().atZone(ZoneOffset.UTC).plus(amount).toInstant();
        return Date.from(instant);
    }

    public static Date plus(Date date, TemporalAmount amount) {
        Instant instant = Objects.requireNonNull(date, "The date must not be null").toInstant().plus(amount);
        return Date.from(instant);
    }

    public static Date minusYears(Date date, int years) {
        return DateUtil.minusAtUtc(date, Period.ofYears(years));
    }

    public static Date minusMonths(Date date, int months) {
        return DateUtil.minusAtUtc(date, Period.ofMonths(months));
    }

    public static Date minusWeeks(Date date, int weeks) {
        return DateUtil.minus(date, Period.ofWeeks(weeks));
    }

    public static Date minusDays(Date date, long days) {
        return DateUtil.minus(date, Duration.ofDays(days));
    }

    public static Date minusHours(Date date, long hours) {
        return DateUtil.minus(date, Duration.ofHours(hours));
    }

    public static Date minusMinutes(Date date, long minutes) {
        return DateUtil.minus(date, Duration.ofMinutes(minutes));
    }

    public static Date minusSeconds(Date date, long seconds) {
        return DateUtil.minus(date, Duration.ofSeconds(seconds));
    }

    public static Date minusMillis(Date date, long millis) {
        return DateUtil.minus(date, Duration.ofMillis(millis));
    }

    public static Date minusNanos(Date date, long nanos) {
        return DateUtil.minus(date, Duration.ofNanos(nanos));
    }

    public static Date minusAtUtc(Date date, TemporalAmount amount) {
        Instant instant = Objects.requireNonNull(date, "The date must not be null").toInstant().atZone(ZoneOffset.UTC).minus(amount).toInstant();
        return Date.from(instant);
    }

    public static Date minus(Date date, TemporalAmount amount) {
        Instant instant = Objects.requireNonNull(date, "The date must not be null").toInstant().minus(amount);
        return Date.from(instant);
    }

    public static @Nullable String formatDateTime(@Nullable Date date) {
        return DateUtil.format(date, DATETIME_FORMATTER);
    }

    public static @Nullable String formatDate(@Nullable Date date) {
        return DateUtil.format(date, DATE_FORMATTER);
    }

    public static @Nullable String formatTime(@Nullable Date date) {
        return DateUtil.format(date, TIME_FORMATTER);
    }

    public static @Nullable String format(@Nullable Date date, String pattern) {
        return DateUtil.format(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static @Nullable String format(@Nullable Date date, DateTimeFormatter formatter) {
        if (date == null) {
            return null;
        }
        return DateUtil.format(date.toInstant(), formatter);
    }

    public static @Nullable String format(Instant instant, DateTimeFormatter formatter) {
        ZoneId zone = formatter.getZone();
        if (zone == null) {
            return formatter.withZone(ZoneId.systemDefault()).format(instant);
        }
        return formatter.format(instant);
    }

    public static String formatDateTime(TemporalAccessor temporal) {
        return DATETIME_FORMATTER.format(temporal);
    }

    public static String formatDate(TemporalAccessor temporal) {
        return DATE_FORMATTER.format(temporal);
    }

    public static String formatTime(TemporalAccessor temporal) {
        return TIME_FORMATTER.format(temporal);
    }

    public static String format(TemporalAccessor temporal, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.systemDefault()).format(temporal);
    }

    public static Date parse(String dateStr, String pattern) {
        return DateUtil.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static Date parse(String dateStr, DateTimeFormatter format) {
        if (format.getZone() == null) {
            format = format.withZone(ZoneId.systemDefault());
        }
        Instant instant = format.parse((CharSequence)dateStr, DateUtil.instantQuery());
        return Date.from(instant);
    }

    public static <T> T parse(String dateStr, String pattern, TemporalQuery<T> query) {
        return DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.systemDefault()).parse((CharSequence)dateStr, query);
    }

    public static Instant toInstant(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static LocalDateTime toDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toStartOfDay(LocalDate localDate) {
        return localDate.atStartOfDay();
    }

    public static LocalDateTime toEndOfDay(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MAX);
    }

    public static LocalDateTime toDateTime(Date date) {
        return DateUtil.toDateTime(date.toInstant());
    }

    public static Date toDate(LocalDateTime dateTime) {
        return Date.from(DateUtil.toInstant(dateTime));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Calendar toCalendar(LocalDateTime localDateTime) {
        return GregorianCalendar.from(ZonedDateTime.of(localDateTime, ZoneId.systemDefault()));
    }

    public static long toMilliseconds(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toMilliseconds(LocalDate localDate) {
        return DateUtil.toMilliseconds(localDate.atStartOfDay());
    }

    public static LocalDateTime fromCalendar(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        ZoneId zid = tz == null ? ZoneId.systemDefault() : tz.toZoneId();
        return LocalDateTime.ofInstant(calendar.toInstant(), zid);
    }

    public static LocalDateTime fromInstant(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime fromDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime fromMilliseconds(long milliseconds) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), ZoneId.systemDefault());
    }

    public static boolean isAfter(ChronoLocalDateTime<?> self, ChronoLocalDateTime<?> other) {
        return self.isAfter(other);
    }

    public static boolean isBefore(ChronoLocalDateTime<?> self, ChronoLocalDateTime<?> other) {
        return self.isBefore(other);
    }

    public static boolean isEqual(ChronoLocalDateTime<?> self, ChronoLocalDateTime<?> other) {
        return self.isEqual(other);
    }

    public static Duration between(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Period between(LocalDate startDate, LocalDate endDate) {
        return Period.between(startDate, endDate);
    }

    public static Duration between(Date startDate, Date endDate) {
        return Duration.between(startDate.toInstant(), endDate.toInstant());
    }

    public static LocalDateTime parseDateTime(CharSequence dateStr, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return DateUtil.parseDateTime(dateStr, formatter);
    }

    public static LocalDateTime parseDateTime(CharSequence dateStr, DateTimeFormatter formatter) {
        return LocalDateTime.parse(dateStr, formatter);
    }

    public static LocalDateTime parseDateTime(CharSequence dateStr) {
        return DateUtil.parseDateTime(dateStr, DATETIME_FORMATTER);
    }

    public static LocalDateTime parseDateTime(@Nullable CharSequence text, @Nullable String[] parsePatterns) {
        return DateUtil.parseDateTime(text, null, parsePatterns);
    }

    public static LocalDateTime parseDateTime(@Nullable CharSequence text, @Nullable Locale locale, @Nullable String[] parsePatterns) {
        return DateUtil.parse(text, locale, parsePatterns, LocalDateTime::from);
    }

    public static LocalDate parseDate(CharSequence dateStr, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return DateUtil.parseDate(dateStr, formatter);
    }

    public static LocalDate parseDate(CharSequence dateStr, DateTimeFormatter formatter) {
        return LocalDate.parse(dateStr, formatter);
    }

    public static LocalDate parseDate(CharSequence dateStr) {
        return DateUtil.parseDate(dateStr, DATE_FORMATTER);
    }

    public static LocalDate parseDate(@Nullable CharSequence text, @Nullable String[] parsePatterns) {
        return DateUtil.parseDate(text, null, parsePatterns);
    }

    public static LocalDate parseDate(@Nullable CharSequence text, @Nullable Locale locale, @Nullable String[] parsePatterns) {
        return DateUtil.parse(text, locale, parsePatterns, LocalDate::from);
    }

    public static LocalTime parseTime(CharSequence dateStr, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return DateUtil.parseTime(dateStr, formatter);
    }

    public static LocalTime parseTime(CharSequence dateStr, DateTimeFormatter formatter) {
        return LocalTime.parse(dateStr, formatter);
    }

    public static LocalTime parseTime(CharSequence dateStr) {
        return DateUtil.parseTime(dateStr, TIME_FORMATTER);
    }

    public static LocalTime parseTime(@Nullable CharSequence text, @Nullable String[] parsePatterns) {
        return DateUtil.parseTime(text, null, parsePatterns);
    }

    public static LocalTime parseTime(@Nullable CharSequence text, @Nullable Locale locale, @Nullable String[] parsePatterns) {
        return DateUtil.parse(text, locale, parsePatterns, LocalTime::from);
    }

    public static <T> T parse(@Nullable CharSequence text, @Nullable Locale locale, @Nullable String[] parsePatterns, TemporalQuery<T> query) {
        if (text == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        Locale lcl = locale == null ? Locale.getDefault() : locale;
        ZoneId systemZone = ZoneId.systemDefault();
        DateTimeFormatter formatter = null;
        for (String parsePattern : parsePatterns) {
            formatter = DateTimeFormatter.ofPattern(parsePattern, lcl).withZone(systemZone);
            try {
                return formatter.parse(text, query);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new DateTimeParseException("Unable to parse the date: " + text, text, -1);
    }

    public static TemporalQuery<Instant> instantQuery() {
        return INSTANT_QUERY;
    }
}

