/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.retry;

import java.io.IOException;
import lombok.Generated;
import net.dreamlu.mica.core.retry.IRetry;
import net.dreamlu.mica.core.retry.RetryCallback;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleRetry
implements IRetry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleRetry.class);
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private static final long DEFAULT_BACK_OFF_PERIOD = 1L;
    private final int maxAttempts;
    private final long sleepMillis;

    public SimpleRetry() {
        this(3, 1L);
    }

    public SimpleRetry(int maxAttempts) {
        this(maxAttempts, 1L);
    }

    public SimpleRetry(int maxAttempts, long sleepMillis) {
        this.maxAttempts = maxAttempts;
        this.sleepMillis = sleepMillis > 0L ? sleepMillis : 1L;
    }

    @Override
    public <T, E extends Throwable> T execute(RetryCallback<T, E> retryCallback) throws E {
        Throwable lastThrowable = null;
        for (int i = 0; i < this.maxAttempts; ++i) {
            try {
                return retryCallback.call();
            }
            catch (Throwable e) {
                int retryCount = i + 1;
                log.warn("retry on {} times error{}.", (Object)retryCount, (Object)e.getMessage());
                lastThrowable = e;
                if (this.sleepMillis <= 0L || retryCount >= this.maxAttempts) continue;
                ThreadUtil.sleep(this.sleepMillis);
                continue;
            }
        }
        if (lastThrowable == null) {
            lastThrowable = new IOException("retry on " + this.maxAttempts + " times,still fail.");
        }
        throw Exceptions.unchecked(lastThrowable);
    }

    @Generated
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Generated
    public long getSleepMillis() {
        return this.sleepMillis;
    }
}

