/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.exception;

import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import org.jspecify.annotations.Nullable;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 2359767895161832954L;
    private final @Nullable R<?> result;

    public ServiceException(R<?> result) {
        super(result.getMsg());
        this.result = result;
    }

    public ServiceException(IResultCode rCode) {
        this(rCode, rCode.getMsg());
    }

    public ServiceException(IResultCode rCode, String message) {
        super(message);
        this.result = R.fail(rCode, message);
    }

    public ServiceException(String message) {
        super(message);
        this.result = null;
    }

    public ServiceException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.doFillInStackTrace();
        this.result = null;
    }

    public <T> @Nullable R<T> getResult() {
        return this.result;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public Throwable doFillInStackTrace() {
        return super.fillInStackTrace();
    }
}

