/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.beans;

import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.dreamlu.mica.core.beans.CopyProperty;
import net.dreamlu.mica.core.beans.MicaBeanCopierKey;
import net.dreamlu.mica.core.utils.BeanUtil;
import net.dreamlu.mica.core.utils.CollectionUtil;
import net.dreamlu.mica.core.utils.ReflectUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.ClassGenerator;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Converter;
import org.springframework.cglib.core.DefaultGeneratorStrategy;
import org.springframework.cglib.core.DefaultNamingPolicy;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public abstract class MicaBeanCopier {
    private static final String BEAN_NAME_PREFIX = MicaBeanCopier.class.getName();
    private static final Type CONVERTER = TypeUtils.parseType((String)Converter.class.getName());
    private static final Type BEAN_COPIER = TypeUtils.parseType((String)BEAN_NAME_PREFIX);
    private static final Type BEAN_MAP = TypeUtils.parseType((String)Map.class.getName());
    private static final Signature COPY = new Signature("copy", Type.VOID_TYPE, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_OBJECT, CONVERTER});
    private static final Signature CONVERT = TypeUtils.parseSignature((String)"Object convert(Object, Class, Object)");
    private static final Signature BEAN_MAP_GET = TypeUtils.parseSignature((String)"Object get(Object)");
    private static final Type CLASS_UTILS = TypeUtils.parseType((String)ClassUtils.class.getName());
    private static final Signature IS_ASSIGNABLE_VALUE = TypeUtils.parseSignature((String)"boolean isAssignableValue(Class, Object)");
    private static final ConcurrentMap<MicaBeanCopierKey, MicaBeanCopier> BEAN_COPIER_MAP = new ConcurrentHashMap<MicaBeanCopierKey, MicaBeanCopier>();

    public static MicaBeanCopier create(Class source, Class target, boolean useConverter) {
        return MicaBeanCopier.create(source, target, useConverter, false);
    }

    public static MicaBeanCopier create(Class source, Class target, boolean useConverter, boolean nonNull) {
        MicaBeanCopierKey copierKey = new MicaBeanCopierKey(source, target, useConverter, nonNull);
        return CollectionUtil.computeIfAbsent(BEAN_COPIER_MAP, copierKey, key -> {
            Generator gen = new Generator((MicaBeanCopierKey)key);
            gen.setContextClass(MicaBeanCopier.class);
            gen.setNamePrefix(BEAN_NAME_PREFIX);
            gen.setUseCache(true);
            return gen.create();
        });
    }

    public abstract void copy(Object var1, Object var2, @Nullable Converter var3);

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BEAN_NAME_PREFIX);
        private final MicaBeanCopierKey copierKey;
        private final Class source;
        private final Class target;
        private final boolean useConverter;
        private final boolean nonNull;
        private String className;

        Generator(MicaBeanCopierKey copierKey) {
            super(SOURCE);
            this.copierKey = copierKey;
            this.source = copierKey.source();
            this.target = copierKey.target();
            this.useConverter = copierKey.useConverter();
            this.nonNull = copierKey.nonNull();
        }

        public void setNamePrefix(String namePrefix) {
            super.setNamePrefix(namePrefix);
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain((Class)this.source);
        }

        public MicaBeanCopier create() {
            return (MicaBeanCopier)super.create((Object)this.copierKey);
        }

        public void generateClass(ClassVisitor v) {
            Type sourceType = Type.getType((Class)this.source);
            Type targetType = Type.getType((Class)this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(46, 1, this.className, BEAN_COPIER, null, "<generated>");
            EmitUtils.null_constructor((ClassEmitter)ce);
            CodeEmitter e = ce.begin_method(1, COPY, null);
            if (Map.class.isAssignableFrom(this.source)) {
                this.generateClassFormMap(ce, e, sourceType, targetType);
                return;
            }
            PropertyDescriptor[] getters = ReflectUtil.getBeanGetters(this.source);
            PropertyDescriptor[] setters = ReflectUtil.getBeanSetters(this.target);
            HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>(16);
            for (PropertyDescriptor getter : getters) {
                names.put(getter.getName(), getter);
            }
            Local targetLocal = e.make_local();
            Local sourceLocal = e.make_local();
            e.load_arg(1);
            e.checkcast(targetType);
            e.store_local(targetLocal);
            e.load_arg(0);
            e.checkcast(sourceType);
            e.store_local(sourceLocal);
            for (PropertyDescriptor setter : setters) {
                PropertyDescriptor getter;
                String propName = setter.getName();
                CopyProperty targetIgnoreCopy = ReflectUtil.getAnnotation(this.target, propName, CopyProperty.class);
                if (targetIgnoreCopy != null) {
                    if (targetIgnoreCopy.ignore()) continue;
                    String aliasTargetPropName = targetIgnoreCopy.value();
                    if (StringUtil.isNotBlank(aliasTargetPropName)) {
                        propName = aliasTargetPropName;
                    }
                }
                if ((getter = (PropertyDescriptor)names.get(propName)) == null) continue;
                MethodInfo read = ReflectUtils.getMethodInfo((Member)getter.getReadMethod());
                Method writeMethod = setter.getWriteMethod();
                MethodInfo write = ReflectUtils.getMethodInfo((Member)writeMethod);
                Type returnType = read.getSignature().getReturnType();
                Type setterType = write.getSignature().getArgumentTypes()[0];
                Class<?> getterPropertyType = getter.getPropertyType();
                Class<?> setterPropertyType = setter.getPropertyType();
                Label l0 = e.make_label();
                if (ClassUtils.isAssignable(setterPropertyType, getterPropertyType)) {
                    e.load_local(targetLocal);
                    e.load_local(sourceLocal);
                    e.invoke(read);
                    boolean getterIsPrimitive = getterPropertyType.isPrimitive();
                    boolean setterIsPrimitive = setterPropertyType.isPrimitive();
                    if (this.nonNull) {
                        e.box(returnType);
                        Local var = e.make_local();
                        e.store_local(var);
                        e.load_local(var);
                        e.ifnull(l0);
                        e.load_local(targetLocal);
                        e.load_local(var);
                        e.unbox_or_zero(setterType);
                    } else {
                        if (getterIsPrimitive && !setterIsPrimitive) {
                            e.box(returnType);
                        }
                        if (!getterIsPrimitive && setterIsPrimitive) {
                            e.unbox_or_zero(setterType);
                        }
                    }
                    Generator.invokeWrite(e, write, writeMethod, this.nonNull, l0);
                    continue;
                }
                if (!this.useConverter) continue;
                e.load_local(targetLocal);
                e.load_arg(2);
                e.load_local(sourceLocal);
                e.invoke(read);
                e.box(returnType);
                if (this.nonNull) {
                    Local var = e.make_local();
                    e.store_local(var);
                    e.load_local(var);
                    e.ifnull(l0);
                    e.load_local(targetLocal);
                    e.load_arg(2);
                    e.load_local(var);
                }
                EmitUtils.load_class((CodeEmitter)e, (Type)setterType);
                e.push(propName);
                e.invoke_interface(CONVERTER, CONVERT);
                e.unbox_or_zero(setterType);
                Generator.invokeWrite(e, write, writeMethod, this.nonNull, l0);
            }
            e.return_value();
            e.end_method();
            ce.end_class();
        }

        private static void invokeWrite(CodeEmitter e, MethodInfo write, Method writeMethod, boolean nonNull, Label l0) {
            Class<?> returnType = writeMethod.getReturnType();
            e.invoke(write);
            if (!returnType.equals(Void.TYPE)) {
                e.pop();
            }
            if (nonNull) {
                e.visitLabel(l0);
            }
        }

        protected Object firstInstance(Class type) {
            return BeanUtil.newInstance(type);
        }

        protected Object nextInstance(Object instance) {
            return instance;
        }

        protected Class generate(AbstractClassGenerator.ClassLoaderData data) {
            this.className = this.generateClassName(data);
            try {
                return MethodHandles.lookup().defineClass(DefaultGeneratorStrategy.INSTANCE.generate((ClassGenerator)this)).asSubclass(MicaBeanCopier.class);
            }
            catch (Exception ex) {
                throw new CodeGenerationException((Throwable)ex);
            }
        }

        private String generateClassName(AbstractClassGenerator.ClassLoaderData data) {
            String name = DefaultNamingPolicy.INSTANCE.getClassName(BEAN_NAME_PREFIX, BEAN_NAME_PREFIX, (Object)this.copierKey, data.getUniqueNamePredicate());
            data.reserveName(name);
            return name;
        }

        private void generateClassFormMap(ClassEmitter ce, CodeEmitter e, Type sourceType, Type targetType) {
            PropertyDescriptor[] setters = ReflectUtil.getBeanSetters(this.target);
            Local targetLocal = e.make_local();
            Local sourceLocal = e.make_local();
            e.load_arg(1);
            e.checkcast(targetType);
            e.store_local(targetLocal);
            e.load_arg(0);
            e.checkcast(sourceType);
            e.store_local(sourceLocal);
            Type mapBox = Type.getType(Object.class);
            for (PropertyDescriptor setter : setters) {
                String propName = setter.getName();
                CopyProperty targetIgnoreCopy = ReflectUtil.getAnnotation(this.target, propName, CopyProperty.class);
                if (targetIgnoreCopy != null) {
                    if (targetIgnoreCopy.ignore()) continue;
                    String aliasTargetPropName = targetIgnoreCopy.value();
                    if (StringUtil.isNotBlank(aliasTargetPropName)) {
                        propName = aliasTargetPropName;
                    }
                }
                Method writeMethod = setter.getWriteMethod();
                MethodInfo write = ReflectUtils.getMethodInfo((Member)writeMethod);
                Type setterType = write.getSignature().getArgumentTypes()[0];
                e.load_local(targetLocal);
                e.load_local(sourceLocal);
                e.push(propName);
                e.invoke_interface(BEAN_MAP, BEAN_MAP_GET);
                e.box(mapBox);
                Local var = e.make_local();
                e.store_local(var);
                e.load_local(var);
                Label l0 = e.make_label();
                e.ifnull(l0);
                EmitUtils.load_class((CodeEmitter)e, (Type)setterType);
                e.load_local(var);
                e.invoke_static(CLASS_UTILS, IS_ASSIGNABLE_VALUE, false);
                Label l1 = new Label();
                Class<?> returnType = writeMethod.getReturnType();
                if (this.useConverter) {
                    e.if_jump(153, l1);
                    e.load_local(targetLocal);
                    e.load_local(var);
                    e.unbox_or_zero(setterType);
                    e.invoke(write);
                    if (!returnType.equals(Void.TYPE)) {
                        e.pop();
                    }
                    e.goTo(l0);
                    e.visitLabel(l1);
                    e.load_local(targetLocal);
                    e.load_arg(2);
                    e.load_local(var);
                    EmitUtils.load_class((CodeEmitter)e, (Type)setterType);
                    e.push(propName);
                    e.invoke_interface(CONVERTER, CONVERT);
                } else {
                    e.if_jump(153, l0);
                    e.load_local(targetLocal);
                    e.load_local(var);
                }
                e.unbox_or_zero(setterType);
                e.invoke(write);
                if (!returnType.equals(Void.TYPE)) {
                    e.pop();
                }
                e.visitLabel(l0);
            }
            e.return_value();
            e.end_method();
            ce.end_class();
        }
    }
}

