/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.ObjectUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;

public class NumberUtil
extends NumberUtils {
    static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 45};

    public static int toInt(String str) {
        return ObjectUtil.toInt(str, 0);
    }

    public static int toInt(@Nullable String str, int defaultValue) {
        return ObjectUtil.toInt(str, defaultValue);
    }

    public static long toLong(String str) {
        return ObjectUtil.toLong(str, 0L);
    }

    public static long toLong(@Nullable String str, long defaultValue) {
        return ObjectUtil.toLong(str, defaultValue);
    }

    public static String to62Str(long i) {
        int radix = 62;
        byte[] buf = new byte[65];
        int charPos = 64;
        for (i = -i; i <= (long)(-radix); i /= (long)radix) {
            buf[charPos--] = DIGITS[(int)(-(i % (long)radix))];
        }
        buf[charPos] = DIGITS[(int)(-i)];
        return new String(buf, charPos, 65 - charPos, Charsets.UTF_8);
    }

    public static long form62Str(String s) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        long res = 0L;
        int len = bytes.length;
        int lenIdx = len - 1;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            int idx = b >= 65 && b <= 90 ? b - 29 : (b >= 97 && b <= 122 ? b - 87 : b - 48);
            res = (long)((double)res + (double)idx * Math.pow(62.0, lenIdx - i));
        }
        return res;
    }
}

