/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.auto.aot;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import net.dreamlu.mica.auto.common.MultiSetMap;

final class FactoriesFiles {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    protected static MultiSetMap<String, String> readFactoriesFile(FileObject fileObject, Elements elementUtils) throws IOException {
        Properties properties = new Properties();
        try (InputStream input = fileObject.openInputStream();){
            properties.load(input);
        }
        MultiSetMap<String, String> multiSetMap = new MultiSetMap<String, String>();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> objectEntry : entrySet) {
            String key = (String)objectEntry.getKey();
            String value = (String)objectEntry.getValue();
            if (value == null || value.trim().isEmpty()) continue;
            String[] values = value.split(",");
            Set valueSet = Arrays.stream(values).filter(v -> !v.isEmpty()).map(String::trim).filter(v -> Objects.nonNull(elementUtils.getTypeElement((CharSequence)v))).collect(Collectors.toSet());
            multiSetMap.putAll(key.trim(), valueSet);
        }
        return multiSetMap;
    }

    protected static void writeFactoriesFile(MultiSetMap<String, String> factories, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        writer.write("# Generated by mica-auto www.dreamlu.net\n");
        Set<String> keySet = factories.keySet();
        for (String key : keySet) {
            Set<String> values = factories.get(key);
            if (values == null || values.isEmpty()) continue;
            writer.write(key);
            writer.write("=\\\n  ");
            StringJoiner joiner = new StringJoiner(",\\\n  ");
            for (String value : values) {
                joiner.add(value);
            }
            writer.write(joiner.toString());
            writer.newLine();
        }
        writer.flush();
    }

    private FactoriesFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

