/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import io.grpc.inprocess.InProcessChannelBuilder;
import java.util.Collections;
import java.util.List;
import net.devh.boot.grpc.client.channelfactory.AbstractChannelFactory;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessChannelFactory
extends AbstractChannelFactory<InProcessChannelBuilder> {
    private static final Logger log = LoggerFactory.getLogger(InProcessChannelFactory.class);

    public InProcessChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        this(properties, globalClientInterceptorRegistry, Collections.emptyList());
    }

    public InProcessChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        super(properties, globalClientInterceptorRegistry, channelConfigurers);
    }

    @Override
    protected InProcessChannelBuilder newChannelBuilder(String name) {
        log.debug("Creating new channel: {}", (Object)name);
        return InProcessChannelBuilder.forName((String)name);
    }

    @Override
    protected void configureSecurity(InProcessChannelBuilder builder, String name) {
    }
}

