/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.member;

import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.JavaConstant;

public class HandleInvocation
implements StackManipulation {
    private static final String METHOD_HANDLE_NAME = "java/lang/invoke/MethodHandle";
    private static final String INVOKE_EXACT = "invokeExact";
    private final JavaConstant.MethodType methodType;

    public HandleInvocation(JavaConstant.MethodType methodType) {
        this.methodType = methodType;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitMethodInsn(182, METHOD_HANDLE_NAME, INVOKE_EXACT, this.methodType.getDescriptor(), false);
        int size = this.methodType.getReturnType().getStackSize().getSize() - this.methodType.getParameterTypes().getStackSize();
        return new StackManipulation.Size(size, Math.max(size, 0));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandleInvocation)) {
            return false;
        }
        HandleInvocation other = (HandleInvocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaConstant.MethodType this$methodType = this.methodType;
        JavaConstant.MethodType other$methodType = other.methodType;
        return !(this$methodType == null ? other$methodType != null : !((Object)this$methodType).equals(other$methodType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HandleInvocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaConstant.MethodType $methodType = this.methodType;
        result = result * 59 + ($methodType == null ? 43 : ((Object)$methodType).hashCode());
        return result;
    }
}

