/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl;

import java.util.ArrayList;
import java.util.List;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.mapping.handler.AbstractListHandler;
import net.lab1024.smartdb.mapping.handler.ResultSetHandler;
import net.lab1024.smartdb.mapping.handler.ScalarHandler;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.pagination.PaginateParam;
import net.lab1024.smartdb.pagination.PaginateResult;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.PatternLocationEnum;
import net.lab1024.smartdb.sqlbuilder.SelectSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.SqlBuilderType;

public abstract class AbstractSelectSqlBuilder
extends AbstractSqlBuilder
implements SelectSqlBuilder {
    protected StringBuilder selectClause = new StringBuilder();
    protected StringBuilder fromClause = new StringBuilder();
    protected StringBuilder joinClause = new StringBuilder();
    protected StringBuilder whereClause = new StringBuilder();
    protected StringBuilder groupbyClause = new StringBuilder();
    protected StringBuilder havingClause = new StringBuilder();
    protected StringBuilder orderbyClause = new StringBuilder();
    protected StringBuilder limitClause = null;
    protected List<Object> selectParams = null;
    protected List<Object> whereParams = null;
    protected List<Object> havingParam = null;

    public AbstractSelectSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    private void ensureAddSelectParams(Object ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        if (this.selectParams == null) {
            this.selectParams = new ArrayList<Object>();
        }
        for (Object param : params) {
            this.selectParams.add(param);
        }
    }

    private void ensureAddWhereParams(Object ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        if (this.whereParams == null) {
            this.whereParams = new ArrayList<Object>();
        }
        for (Object param : params) {
            this.whereParams.add(param);
        }
    }

    private void ensureAddHavingParams(Object ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        if (this.havingParam == null) {
            this.havingParam = new ArrayList<Object>();
        }
        for (Object param : params) {
            this.havingParam.add(param);
        }
    }

    @Override
    public SqlBuilderType getSqlBuilderType() {
        return SqlBuilderType.SELECT;
    }

    public SelectSqlBuilder appendSql(String sqlClause) {
        this.appendSqlBuilder.append(" ").append(sqlClause);
        return this;
    }

    @Override
    public SelectSqlBuilder select(String columns) {
        if (this.selectClause.length() == 0) {
            this.selectClause.append("SELECT ").append(columns);
        } else {
            this.selectClause.append(" , ").append(columns);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder select(String columns, Object ... params) {
        this.select(columns);
        this.ensureAddSelectParams(params);
        return this;
    }

    @Override
    public SelectSqlBuilder from(String table) {
        if (this.fromClause.length() == 0) {
            this.fromClause.append(" FROM ").append(table);
        } else {
            this.fromClause.append(" , ").append(table);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder from(String ... tables) {
        if (tables != null && tables.length > 0) {
            this.from(tables[0]);
            for (int i = 1; i < tables.length; ++i) {
                this.fromClause.append(" ").append(",").append(tables[i]);
            }
        }
        return this;
    }

    @Override
    public SelectSqlBuilder from(Class entityClass) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(entityClass);
        if (classMeta != null) {
            this.from(classMeta.getTableName(this.tableNameConverter));
        }
        return this;
    }

    @Override
    public SelectSqlBuilder from(Class entityClass, String aliasTableName) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(entityClass);
        if (classMeta != null) {
            this.from(classMeta.getTableName(this.tableNameConverter));
            if (aliasTableName != null) {
                this.fromClause.append(" ").append(aliasTableName);
            }
        }
        return this;
    }

    @Override
    public SelectSqlBuilder joinInner(String joinClause) {
        if (this.joinClause.length() == 0) {
            this.joinClause.append(" INNER JOIN ").append(joinClause);
        } else {
            this.joinClause.append(" ").append(" INNER JOIN ").append(joinClause);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder joinRight(String joinClause) {
        if (this.joinClause.length() == 0) {
            this.joinClause.append(" RIGHT JOIN ").append(joinClause);
        } else {
            this.joinClause.append(" ").append(" RIGHT JOIN ").append(joinClause);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder joinLeft(String joinClause) {
        if (this.joinClause.length() == 0) {
            this.joinClause.append(" LEFT JOIN ").append(joinClause);
        } else {
            this.joinClause.append(" ").append(" LEFT JOIN ").append(joinClause);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder joinFull(String joinClause) {
        if (this.joinClause.length() == 0) {
            this.joinClause.append(" FULL JOIN ").append(joinClause);
        } else {
            this.joinClause.append(" ").append(" FULL JOIN ").append(joinClause);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder whereAnd(String where) {
        this.ensureAppendWhereAnd(where);
        return this;
    }

    @Override
    public <T> SelectSqlBuilder whereAndIn(String column, List<T> inList) {
        if (inList == null || inList.isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(column).append(" in (");
        sb.append("'").append(inList.get(0).toString()).append("'");
        int len = inList.size();
        for (int i = 1; i < len; ++i) {
            sb.append(",'").append(inList.get(i).toString()).append("'");
        }
        sb.append(") ");
        this.ensureAppendWhereAnd(sb.toString());
        return this;
    }

    @Override
    public <T> SelectSqlBuilder whereAndNotIn(String column, List<T> inList) {
        if (inList == null || inList.isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(column).append(" not in (");
        sb.append("'").append(inList.get(0).toString()).append("'");
        int len = inList.size();
        for (int i = 1; i < len; ++i) {
            sb.append(",'").append(inList.get(i).toString()).append("'");
        }
        sb.append(") ");
        this.ensureAppendWhereAnd(sb.toString());
        return this;
    }

    private void ensureAppendWhereAnd(String where) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append("WHERE ").append(where);
        } else {
            this.whereClause.append(" AND ").append(where);
        }
    }

    private void ensureAppendWhereOr(String where) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append("WHERE ").append(where);
        } else {
            this.whereClause.append(" OR ").append(where);
        }
    }

    @Override
    public SelectSqlBuilder whereAnd(String where, Object ... param) {
        this.ensureAppendWhereAnd(where);
        this.ensureAddWhereParams(param);
        return this;
    }

    @Override
    public SelectSqlBuilder whereOr(String where) {
        this.ensureAppendWhereOr(where);
        return this;
    }

    @Override
    public SelectSqlBuilder whereOr(String where, Object ... param) {
        this.ensureAppendWhereOr(where);
        this.ensureAddWhereParams(param);
        return this;
    }

    @Override
    public SelectSqlBuilder whereOrLikeColumns(String like, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(like, false, column);
        return this;
    }

    @Override
    public SelectSqlBuilder whereOrLikePatterns(String column, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiLikes(column, false, likes);
        return this;
    }

    @Override
    public SelectSqlBuilder groupby(String groupby) {
        if (this.groupbyClause.length() == 0) {
            this.groupbyClause.append("GROUP BY ").append(groupby);
        } else {
            this.groupbyClause.append(",").append(groupby);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder havingAnd(String condition) {
        if (this.havingClause.length() == 0) {
            this.havingClause.append("HAVING ").append(condition);
        } else {
            this.havingClause.append(" AND ").append(condition);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder havingAnd(String condition, Object ... param) {
        this.havingAnd(condition);
        this.ensureAddHavingParams(param);
        return this;
    }

    @Override
    public SelectSqlBuilder havingOr(String condition) {
        if (this.havingClause.length() == 0) {
            this.havingClause.append("HAVING ").append(condition);
        } else {
            this.havingClause.append(" OR ").append(condition);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder havingOr(String condition, Object ... param) {
        this.havingOr(condition);
        this.ensureAddHavingParams(param);
        return this;
    }

    @Override
    public SelectSqlBuilder orderby(String column, boolean isAsc) {
        if (this.orderbyClause.length() == 0) {
            this.orderbyClause.append("ORDER BY ").append(column).append(isAsc ? " ASC" : " DESC");
        } else {
            this.orderbyClause.append(" ,").append(column).append(isAsc ? " ASC" : " DESC");
        }
        return this;
    }

    @Override
    public SelectSqlBuilder orderby(String orderbyClauseString) {
        if (this.orderbyClause.length() == 0) {
            this.orderbyClause.append("ORDER BY ").append(orderbyClauseString);
        } else {
            this.orderbyClause.append(" ,").append(orderbyClauseString);
        }
        return this;
    }

    @Override
    public SelectSqlBuilder limit(long offset, long rowCount) {
        this.limitClause = new StringBuilder();
        this.limitClause.append("LIMIT ").append(offset).append(",").append(rowCount);
        return this;
    }

    @Override
    public String generateSql() {
        return this.generateSql(false);
    }

    @Override
    public String generateSql(boolean isPretty) {
        StringBuilder selectSqlBuilder = new StringBuilder();
        if (this.selectClause != null && this.selectClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.selectClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.fromClause != null && this.fromClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.fromClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.joinClause != null && this.joinClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.joinClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.whereClause != null && this.whereClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.whereClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.groupbyClause != null && this.groupbyClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.groupbyClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.havingClause != null && this.havingClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.havingClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.orderbyClause != null && this.orderbyClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.orderbyClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        if (this.limitClause != null && this.limitClause.length() > 0) {
            selectSqlBuilder.append((CharSequence)this.limitClause).append(isPretty ? LINE_SEPARATOR : " ");
        }
        selectSqlBuilder.append((CharSequence)this.appendSqlBuilder);
        return selectSqlBuilder.toString();
    }

    private String percentSignFormat(PatternLocationEnum location, String str) {
        if (location == PatternLocationEnum.AROUND) {
            return String.format("%%%s%%", str);
        }
        if (location == PatternLocationEnum.SUFFIX) {
            return String.format("%s%%", str);
        }
        if (location == PatternLocationEnum.PREFIX) {
            return String.format("%%%s", str);
        }
        throw new RuntimeException("cannot found PatternLocationEnum " + (Object)((Object)location));
    }

    private void appendLikeClause4MultiColumns(String finalLike, boolean isAndThenOr, String ... column) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append(" WHERE ");
        } else {
            this.whereClause.append(isAndThenOr ? " AND " : " OR ");
        }
        int len = column.length - 1;
        if (column.length > 0) {
            this.whereClause.append("( ");
            for (int i = 0; i < column.length; ++i) {
                if (len == i) {
                    this.whereClause.append(column[i]).append(" LIKE '").append(finalLike).append("' ");
                    continue;
                }
                this.whereClause.append(column[i]).append(" LIKE '").append(finalLike).append("' OR ");
            }
            this.whereClause.append(")");
        } else {
            this.whereClause.append(column[0]).append(" LIKE '").append(finalLike).append("' ");
        }
    }

    private void appendLikeClause4MultiLikes(String column, boolean isAndThenOr, String ... finalLikes) {
        if (this.whereClause.length() == 0) {
            this.whereClause.append(" WHERE ");
        } else {
            this.whereClause.append(isAndThenOr ? " AND " : " OR ");
        }
        int len = finalLikes.length - 1;
        if (finalLikes.length > 0) {
            this.whereClause.append("( ");
            for (int i = 0; i < finalLikes.length; ++i) {
                if (len == i) {
                    this.whereClause.append(column).append(" LIKE '").append(finalLikes[i]).append("' ");
                    continue;
                }
                this.whereClause.append(column).append(" LIKE '").append(finalLikes[i]).append("' OR ");
            }
            this.whereClause.append(")");
        } else {
            this.whereClause.append(column).append(" LIKE '").append(finalLikes[0]).append("' ");
        }
    }

    @Override
    public SelectSqlBuilder whereAndLikeColumns(String like, String ... column) {
        if (column == null || column.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiColumns(like, true, column);
        return this;
    }

    @Override
    public SelectSqlBuilder whereAndLikePatterns(String column, String ... likes) {
        if (likes == null || likes.length < 1) {
            return this;
        }
        this.appendLikeClause4MultiLikes(column, true, likes);
        return this;
    }

    @Override
    public <T> SelectSqlBuilder whereOrIn(String column, List<T> inList) {
        if (inList == null || inList.isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(column).append(" in (");
        sb.append("'").append(inList.get(0).toString()).append("'");
        int len = inList.size();
        for (int i = 1; i < len; ++i) {
            sb.append(",'").append(inList.get(i).toString()).append("'");
        }
        sb.append(") ");
        this.ensureAppendWhereOr(sb.toString());
        return this;
    }

    @Override
    public List<Object> getSelectParams() {
        return this.selectParams;
    }

    @Override
    public List<Object> getWhereParams() {
        return this.whereParams;
    }

    @Override
    public List<Object> getHavingParams() {
        return this.havingParam;
    }

    @Override
    public List<Object> getAllParams() {
        int count = this.selectParams == null ? 0 : this.selectParams.size() + (this.whereParams == null ? 0 : this.whereParams.size()) + (this.havingParam == null ? 0 : this.havingParam.size());
        ArrayList<Object> list = new ArrayList<Object>(count);
        if (this.selectParams != null) {
            list.addAll(this.selectParams);
        }
        if (this.whereParams != null) {
            list.addAll(this.whereParams);
        }
        if (this.havingParam != null) {
            list.addAll(this.havingParam);
        }
        return list;
    }

    public String toString() {
        return this.generateSql();
    }

    @Override
    public <T> T queryFirst(Class<T> cls) {
        return this.smartDbNode.queryFirst(cls, this);
    }

    @Override
    public <T> T queryFirst(ScalarHandler<T> resultSetHandler) {
        return this.smartDbNode.query(resultSetHandler, this);
    }

    @Override
    public <T> List<T> queryList(AbstractListHandler<T> resultSetHandler) {
        return (List)this.smartDbNode.query(resultSetHandler, this);
    }

    @Override
    public <T> List<T> queryList(Class<T> cls) {
        return this.smartDbNode.queryList(cls, this);
    }

    @Override
    public <T> PaginateResult<T> paginate(Class<T> cls, PaginateParam paginateParam) {
        return this.smartDbNode.paginate(cls, paginateParam, (SelectSqlBuilder)this);
    }

    @Override
    public <T> PaginateResult<T> paginate(AbstractListHandler<T> handler, PaginateParam paginateParam) {
        return this.smartDbNode.paginate(handler, paginateParam, (SelectSqlBuilder)this);
    }

    @Override
    public <T> T query(ResultSetHandler<T> handler) {
        return this.smartDbNode.query(handler, this);
    }
}

