/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.sqlbuilder.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.lab1024.smartdb.SmartDbNode;
import net.lab1024.smartdb.exception.SmartDbException;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.mapping.reflect.OrmClassMeta;
import net.lab1024.smartdb.mapping.reflect.SmartDbOrmClassMetaCache;
import net.lab1024.smartdb.sqlbuilder.AbstractSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.InsertSqlBuilder;
import net.lab1024.smartdb.sqlbuilder.SqlBuilderType;
import net.lab1024.smartdb.sqlbuilder.convertor.ColumnNameConverter;

public abstract class AbstractInsertSqlBuilder
extends AbstractSqlBuilder
implements InsertSqlBuilder {
    protected String table;
    protected OrmClassFieldMeta[] useGeneratedKeyFields;
    protected Map<String, InsertParamObject> columnAndParam = new LinkedHashMap<String, InsertParamObject>();

    public AbstractInsertSqlBuilder(SmartDbNode smartDbNode) {
        super(smartDbNode);
    }

    @Override
    public SqlBuilderType getSqlBuilderType() {
        return SqlBuilderType.INSERT;
    }

    @Override
    public InsertSqlBuilder table(String table) {
        if (table != null) {
            this.table = table;
        }
        return this;
    }

    @Override
    public InsertSqlBuilder table(Class clazz) {
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(clazz);
        if (classMeta != null) {
            this.table(classMeta.getTableName(this.tableNameConverter));
        }
        return this;
    }

    public InsertSqlBuilder appendSql(String sqlClause) {
        this.appendSqlBuilder.append(" ").append(sqlClause);
        return this;
    }

    @Override
    public InsertSqlBuilder insertColumn(String column, Object param) {
        this.columnAndParam.put(column, new InsertParamObject(false, param));
        return this;
    }

    @Override
    public InsertSqlBuilder insertFunctionColumn(String column, String sqlFunction) {
        this.columnAndParam.put(column, new InsertParamObject(true, sqlFunction));
        return this;
    }

    @Override
    public InsertSqlBuilder insertEntitySelective(Object obj) {
        return this.insertEntitySelective(obj, this.columnNameConverter);
    }

    @Override
    public InsertSqlBuilder insertEntitySelective(Object obj, ColumnNameConverter columnNameConverter) {
        this.reflectFieldAndInsert(obj, columnNameConverter, true);
        return this;
    }

    private void reflectFieldAndInsert(Object obj, ColumnNameConverter columnNameConverter, boolean ignoreNull) {
        Class<?> cls = obj.getClass();
        OrmClassMeta classMeta = SmartDbOrmClassMetaCache.getClassMeta(cls);
        this.table(classMeta.getTableName(this.tableNameConverter));
        try {
            OrmClassFieldMeta[] primaryKeyFields = classMeta.getPrimaryKeyFields();
            this.useGeneratedKeyFields = classMeta.getUseGeneratedKeyFields();
            for (int i = 0; i < primaryKeyFields.length; ++i) {
                OrmClassFieldMeta f = primaryKeyFields[i];
                Object o = f.getField().get(obj);
                if (o == null) continue;
                String name = f.getOrmColumnName();
                if (columnNameConverter != null) {
                    name = columnNameConverter.fieldConvertToColumn(name);
                }
                this.insertColumn(name, o);
            }
            for (OrmClassFieldMeta f : classMeta.getColumnsFields()) {
                Object o = f.getField().get(obj);
                if (ignoreNull && o == null) continue;
                String name = f.getOrmColumnName();
                if (columnNameConverter != null) {
                    name = columnNameConverter.fieldConvertToColumn(name);
                }
                this.insertColumn(name, o);
            }
        }
        catch (IllegalAccessException e) {
            throw new SmartDbException(e);
        }
    }

    @Override
    public InsertSqlBuilder insertEntity(Object obj) {
        return this.insertEntity(obj, this.columnNameConverter);
    }

    @Override
    public InsertSqlBuilder insertEntity(Object obj, ColumnNameConverter columnNameConverter) {
        this.reflectFieldAndInsert(obj, columnNameConverter, false);
        return this;
    }

    @Override
    public String generateSql() {
        return this.generateSql(false);
    }

    public String toString() {
        return this.generateSql(false);
    }

    @Override
    public List<Object> getAllParams() {
        ArrayList<Object> list = new ArrayList<Object>(this.columnAndParam.size());
        for (InsertParamObject param : this.columnAndParam.values()) {
            if (param.isSqlFunction) continue;
            list.add(param.param);
        }
        return list;
    }

    @Override
    public int execute() {
        return this.smartDbNode.execute(this);
    }

    protected class InsertParamObject {
        protected boolean isSqlFunction;
        Object param;

        public boolean isSqlFunction() {
            return this.isSqlFunction;
        }

        public Object getParam() {
            return this.param;
        }

        public InsertParamObject(boolean isSqlFunction, Object param) {
            this.isSqlFunction = isSqlFunction;
            this.param = param;
        }
    }
}

