/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.reflect;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import net.lab1024.smartdb.annotation.ColumnAlias;
import net.lab1024.smartdb.annotation.ColumnIgnore;
import net.lab1024.smartdb.annotation.PrimaryKey;
import net.lab1024.smartdb.annotation.TableAlias;
import net.lab1024.smartdb.annotation.UseGeneratedKey;
import net.lab1024.smartdb.mapping.reflect.OrmClassFieldMeta;
import net.lab1024.smartdb.sqlbuilder.convertor.TableNameConverter;

public class OrmClassMeta {
    private Class<?> cls;
    private String tableName;
    private OrmClassFieldMeta[] primaryKeyFields;
    private OrmClassFieldMeta[] columnsFields;
    private OrmClassFieldMeta[] useGeneratedKeyFields;
    private boolean isUseGeneratedKey = false;

    OrmClassMeta(Class cls) {
        this.cls = cls;
        ArrayList<OrmClassFieldMeta> primaryList = new ArrayList<OrmClassFieldMeta>();
        ArrayList<OrmClassFieldMeta> columnsFieldsList = new ArrayList<OrmClassFieldMeta>();
        ArrayList<OrmClassFieldMeta> useGeneratedKeyFieldsList = new ArrayList<OrmClassFieldMeta>();
        while (cls != Object.class) {
            Field[] fields;
            TableAlias tableAnno = this.cls.getAnnotation(TableAlias.class);
            if (this.tableName == null && tableAnno != null && tableAnno.value() != null && tableAnno.value().length() > 0) {
                this.tableName = tableAnno.value();
            }
            for (Field f : fields = cls.getDeclaredFields()) {
                ColumnIgnore annotation = f.getAnnotation(ColumnIgnore.class);
                if (annotation != null) continue;
                f.setAccessible(true);
                ColumnAlias columnAliasAnno = f.getAnnotation(ColumnAlias.class);
                String columnAlias = columnAliasAnno == null ? null : columnAliasAnno.value();
                PrimaryKey primaryKey = f.getAnnotation(PrimaryKey.class);
                if (primaryKey != null) {
                    primaryList.add(new OrmClassFieldMeta(columnAlias, f));
                } else {
                    columnsFieldsList.add(new OrmClassFieldMeta(columnAlias, f));
                }
                UseGeneratedKey useGeneratedKey = f.getAnnotation(UseGeneratedKey.class);
                if (useGeneratedKey == null) continue;
                useGeneratedKeyFieldsList.add(new OrmClassFieldMeta(columnAlias, f));
            }
            cls = cls.getSuperclass();
        }
        this.primaryKeyFields = primaryList.toArray(new OrmClassFieldMeta[primaryList.size()]);
        this.columnsFields = columnsFieldsList.toArray(new OrmClassFieldMeta[columnsFieldsList.size()]);
        this.useGeneratedKeyFields = useGeneratedKeyFieldsList.toArray(new OrmClassFieldMeta[useGeneratedKeyFieldsList.size()]);
        this.isUseGeneratedKey = useGeneratedKeyFieldsList.size() > 0;
    }

    public OrmClassFieldMeta[] getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public OrmClassFieldMeta[] getUseGeneratedKeyFields() {
        return this.useGeneratedKeyFields;
    }

    public boolean isUseGeneratedKey() {
        return this.isUseGeneratedKey;
    }

    public OrmClassFieldMeta[] getColumnsFields() {
        return this.columnsFields;
    }

    public String getTableName(TableNameConverter tableNameConverter) {
        if (this.tableName == null) {
            return tableNameConverter.classToTableName(this.cls);
        }
        return this.tableName;
    }

    private Object convert2Long(Object val) {
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).longValue();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).longValue();
        }
        if (val instanceof Long) {
            return (long)((Long)val);
        }
        return ((Integer)val).longValue();
    }

    private Integer convert2Integer(Object val) {
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).intValue();
        }
        return (int)((Integer)val);
    }

    public <T> void injectGeneratedKeys(ResultSet rs, T t) throws SQLException, IllegalAccessException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            OrmClassFieldMeta ormClassFieldMeta = this.useGeneratedKeyFields[i];
            if (ormClassFieldMeta == null) continue;
            Class<?> type = ormClassFieldMeta.getField().getType();
            Object value = rs.getObject(i + 1);
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                ormClassFieldMeta.getField().set(t, this.convert2Integer(value));
                return;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                ormClassFieldMeta.getField().set(t, this.convert2Long(value));
                return;
            }
            ormClassFieldMeta.getField().set(t, value);
        }
    }
}

