/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.handler.type;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.lab1024.smartdb.SmartDbEnum;
import net.lab1024.smartdb.mapping.handler.type.BigDecimalTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.BlobByteObjectArrayTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.BlobInputStreamTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.BlobTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.BooleanTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ByteArrayTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ByteObjectArrayTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ByteTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.CharacterTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ClobReaderTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.DateTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.DoubleTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.EnumTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.FloatTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.InstantTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.IntegerTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.LocalDateTimeTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.LocalDateTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.LocalTimeTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.LongTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.MonthTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ObjectTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.OffsetDateTimeTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.OffsetTimeTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ShortTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.SmartDbEnumTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.SqlDateTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.SqlTimeTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.SqlTimestampTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.StringTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.TypeHandler;
import net.lab1024.smartdb.mapping.handler.type.YearMonthTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.YearTypeHandler;
import net.lab1024.smartdb.mapping.handler.type.ZonedDateTimeTypeHandler;

public class TypeHandlerFactory {
    private static final ConcurrentHashMap<Class, TypeHandler<?>> enumHandlerMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class, TypeHandler<? extends SmartDbEnum>> smartDbEnumHandlerMap = new ConcurrentHashMap();
    private static final Map<Class<?>, TypeHandler<?>> typeHandlerMap = new HashMap();

    public static <T extends Enum> TypeHandler<T> getEnumTypeHandler(Class<T> cls) {
        TypeHandler<?> typeHandler = enumHandlerMap.get(cls);
        if (typeHandler == null) {
            typeHandler = new EnumTypeHandler<T>(cls);
            enumHandlerMap.put(cls, typeHandler);
        }
        return typeHandler;
    }

    public static <T extends SmartDbEnum> TypeHandler<?> getSmartDbEnumTypeHandler(Class<T> cls) {
        TypeHandler<? extends SmartDbEnum> typeHandler = smartDbEnumHandlerMap.get(cls);
        if (typeHandler == null) {
            typeHandler = new SmartDbEnumTypeHandler<SmartDbEnum>(cls);
            smartDbEnumHandlerMap.put(cls, typeHandler);
        }
        return typeHandler;
    }

    private static void register(Class javaType, TypeHandler<?> handler) {
        typeHandlerMap.put(javaType, handler);
    }

    public static TypeHandler<?> getHandler(Class<?> cls) {
        return typeHandlerMap.get(cls);
    }

    static {
        TypeHandlerFactory.register(Boolean.class, new BooleanTypeHandler());
        TypeHandlerFactory.register(Boolean.TYPE, new BooleanTypeHandler());
        TypeHandlerFactory.register(Byte.class, new ByteTypeHandler());
        TypeHandlerFactory.register(Byte.TYPE, new ByteTypeHandler());
        TypeHandlerFactory.register(Short.class, new ShortTypeHandler());
        TypeHandlerFactory.register(Short.TYPE, new ShortTypeHandler());
        TypeHandlerFactory.register(Integer.class, new IntegerTypeHandler());
        TypeHandlerFactory.register(Integer.TYPE, new IntegerTypeHandler());
        TypeHandlerFactory.register(Long.class, new LongTypeHandler());
        TypeHandlerFactory.register(Long.TYPE, new LongTypeHandler());
        TypeHandlerFactory.register(Float.class, new FloatTypeHandler());
        TypeHandlerFactory.register(Float.TYPE, new FloatTypeHandler());
        TypeHandlerFactory.register(Double.class, new DoubleTypeHandler());
        TypeHandlerFactory.register(Double.TYPE, new DoubleTypeHandler());
        TypeHandlerFactory.register(Character.class, new CharacterTypeHandler());
        TypeHandlerFactory.register(Character.TYPE, new CharacterTypeHandler());
        TypeHandlerFactory.register(Reader.class, new ClobReaderTypeHandler());
        TypeHandlerFactory.register(String.class, new StringTypeHandler());
        TypeHandlerFactory.register(Object.class, new ObjectTypeHandler());
        TypeHandlerFactory.register(BigDecimal.class, new BigDecimalTypeHandler());
        TypeHandlerFactory.register(InputStream.class, new BlobInputStreamTypeHandler());
        TypeHandlerFactory.register(Byte[].class, new ByteObjectArrayTypeHandler());
        TypeHandlerFactory.register(Byte[].class, new BlobByteObjectArrayTypeHandler());
        TypeHandlerFactory.register(Byte[].class, new BlobByteObjectArrayTypeHandler());
        TypeHandlerFactory.register(byte[].class, new ByteArrayTypeHandler());
        TypeHandlerFactory.register(byte[].class, new BlobTypeHandler());
        TypeHandlerFactory.register(byte[].class, new BlobTypeHandler());
        TypeHandlerFactory.register(java.util.Date.class, new DateTypeHandler());
        TypeHandlerFactory.register(Date.class, new SqlDateTypeHandler());
        TypeHandlerFactory.register(Time.class, new SqlTimeTypeHandler());
        TypeHandlerFactory.register(Timestamp.class, new SqlTimestampTypeHandler());
        TypeHandlerFactory.register(Instant.class, new InstantTypeHandler());
        TypeHandlerFactory.register(LocalDateTime.class, new LocalDateTimeTypeHandler());
        TypeHandlerFactory.register(LocalDate.class, new LocalDateTypeHandler());
        TypeHandlerFactory.register(LocalTime.class, new LocalTimeTypeHandler());
        TypeHandlerFactory.register(OffsetDateTime.class, new OffsetDateTimeTypeHandler());
        TypeHandlerFactory.register(OffsetTime.class, new OffsetTimeTypeHandler());
        TypeHandlerFactory.register(ZonedDateTime.class, new ZonedDateTimeTypeHandler());
        TypeHandlerFactory.register(Month.class, new MonthTypeHandler());
        TypeHandlerFactory.register(Year.class, new YearTypeHandler());
        TypeHandlerFactory.register(YearMonth.class, new YearMonthTypeHandler());
    }
}

