/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.mapping.handler.type;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.lab1024.smartdb.mapping.handler.type.JdbcType;
import net.lab1024.smartdb.mapping.handler.type.TypeHandler;

public class EnumTypeHandler<E extends Enum<E>>
implements TypeHandler<E> {
    private final Class<E> type;

    public EnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    @Override
    public E getResult(ResultSet rs, int columnIndex, JdbcType jdbcType) throws SQLException {
        String s = rs.getString(columnIndex);
        return s == null ? null : (E)Enum.valueOf(this.type, s);
    }

    @Override
    public E getResult(ResultSet rs, String columnName, JdbcType jdbcType) throws SQLException {
        String s = rs.getString(columnName);
        return s == null ? null : (E)Enum.valueOf(this.type, s);
    }
}

