/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.lab1024.smartdb.AbstractSmartDbNode;
import net.lab1024.smartdb.SmartDbConfig;
import net.lab1024.smartdb.TransactionSmartDbNode;
import net.lab1024.smartdb.datasource.SmartDbDataSource;
import net.lab1024.smartdb.mapping.handler.ScalarHandler;
import net.lab1024.smartdb.pagination.PaginateParam;
import net.lab1024.smartdb.pagination.PaginateResult;
import net.lab1024.smartdb.sqlbuilder.ReplaceSqlBuilder;

public class OracleSmartDbImpl
extends AbstractSmartDbNode {
    public OracleSmartDbImpl(SmartDbDataSource dataSource, SmartDbConfig smartDbConfig) {
        super(dataSource, smartDbConfig);
    }

    @Override
    public TransactionSmartDbNode getTransaction() {
        return new Oracle4Transaction(this.smartDbDataSource, this.smartDbConfig);
    }

    @Override
    public int execute(ReplaceSqlBuilder replaceSqlBuilder) {
        throw new UnsupportedOperationException("oracle cannot support replace operate");
    }

    @Override
    public <T> PaginateResult<T> paginate(Class<T> handler, PaginateParam paginateParam, String sql, Object ... params) {
        int pageNumber = paginateParam.getPageNumber();
        int pageSize = paginateParam.getPageSize();
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        Integer total = 0;
        if (paginateParam.isSearchCount()) {
            String totalRowSql = this.getSupportDatabaseType().getPaginateSqlGenerator().generateCountSql(pageNumber, pageSize, sql);
            total = this.query(ScalarHandler.BigDecimal, totalRowSql, params).intValue();
            if (total == null || total == 0) {
                return new PaginateResult(pageNumber, pageSize);
            }
            int pageCount = total / pageSize;
            if (total % pageSize != 0) {
                ++pageCount;
            }
            if (pageNumber > pageCount) {
                return new PaginateResult(new ArrayList(0), total.intValue(), pageNumber, pageSize);
            }
        }
        String pageSql = this.getSupportDatabaseType().getPaginateSqlGenerator().generatePaginateSql(pageNumber, pageSize, sql);
        List<T> list = this.queryList(handler, pageSql, params);
        return new PaginateResult<T>(list, total.intValue(), pageNumber, pageSize);
    }

    private class Oracle4Transaction
    extends OracleSmartDbImpl
    implements TransactionSmartDbNode {
        private Connection transactionConn;
        private Boolean originalAutoCommit;

        public Oracle4Transaction(SmartDbDataSource dataSource, SmartDbConfig smartDbConfig) {
            super(dataSource, smartDbConfig);
        }

        @Override
        public TransactionSmartDbNode getTransaction() {
            return this;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.getTransactionConnection();
        }

        @Override
        public void rollback() throws SQLException {
            this.getTransactionConnection().rollback();
        }

        @Override
        public void begin(int transactionLevel) throws SQLException {
            this.originalAutoCommit = this.getTransactionConnection().getAutoCommit();
            this.transactionConn.setTransactionIsolation(transactionLevel);
            this.transactionConn.setAutoCommit(false);
        }

        @Override
        public void begin() throws SQLException {
            this.getTransactionConnection().setAutoCommit(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getTransactionConnection() throws SQLException {
            if (this.transactionConn == null) {
                Oracle4Transaction oracle4Transaction = this;
                synchronized (oracle4Transaction) {
                    if (this.transactionConn == null) {
                        this.transactionConn = this.smartDbDataSource.getConnection();
                    }
                }
            }
            return this.transactionConn;
        }

        @Override
        public void releaseResources(ResultSet rs, Statement stmt, Connection conn) {
            super.releaseResources(rs, stmt, null);
        }

        @Override
        public void commit() throws SQLException {
            this.getTransactionConnection().commit();
        }

        @Override
        public void releaseConnection() {
            if (this.transactionConn != null) {
                if (this.originalAutoCommit != null) {
                    try {
                        this.transactionConn.setAutoCommit(this.originalAutoCommit);
                    }
                    catch (SQLException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
                this.smartDbDataSource.releaseConnection(this.transactionConn);
                this.transactionConn = null;
            }
        }
    }
}

