/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.codegenerator;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import net.lab1024.smartdb.codegenerator.SmartDbEntityGenerator;
import net.lab1024.smartdb.database.SupportDatabaseType;
import net.lab1024.smartdb.exception.SmartDbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartDbEntityGeneratorBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SmartDbEntityGeneratorBuilder.class);
    protected String driverClassName;
    protected String username;
    protected String password;
    protected String jdbcUrl;
    protected String tableName;
    protected boolean isComment;
    protected String packageName;
    protected String className;
    protected boolean isGenerateGetterSetter;
    protected SupportDatabaseType supportDatabaseType;
    protected boolean isFieldBasicType = false;
    protected String entityClassFileDir;
    protected CaseFormat tableColumnCaseFormat;
    protected CaseFormat entityFieldCaseFormat;

    SupportDatabaseType getSupportDatabaseType() {
        return this.supportDatabaseType;
    }

    public void build() {
        Objects.requireNonNull(this.supportDatabaseType);
        Class smartDbEntityGeneratorClass = this.supportDatabaseType.getSmartDbEntityGeneratorClass();
        try {
            Constructor constructor = smartDbEntityGeneratorClass.getConstructor(this.getClass());
            constructor.setAccessible(true);
            SmartDbEntityGenerator smartDbEntityGenerator = (SmartDbEntityGenerator)constructor.newInstance(this);
            smartDbEntityGenerator.generate();
        }
        catch (Exception e) {
            throw new SmartDbException(e);
        }
    }

    public SmartDbEntityGeneratorBuilder setSupportDatabaseType(SupportDatabaseType supportDatabaseType) {
        this.supportDatabaseType = supportDatabaseType;
        return this;
    }

    public boolean isFieldBasicType() {
        return this.isFieldBasicType;
    }

    public SmartDbEntityGeneratorBuilder setFieldBasicType(boolean fieldBasicType) {
        this.isFieldBasicType = fieldBasicType;
        return this;
    }

    public SmartDbEntityGeneratorBuilder setGenerateGetterSetter(boolean generateGetterSetter) {
        this.isGenerateGetterSetter = generateGetterSetter;
        return this;
    }

    public String getEntityClassFileDir() {
        return this.entityClassFileDir;
    }

    public SmartDbEntityGeneratorBuilder setEntityClassFileDir(String entityClassFileDir) {
        this.entityClassFileDir = entityClassFileDir;
        return this;
    }

    public CaseFormat getTableColumnCaseFormat() {
        return this.tableColumnCaseFormat;
    }

    public SmartDbEntityGeneratorBuilder setTableColumnCaseFormat(CaseFormat tableColumnCaseFormat) {
        this.tableColumnCaseFormat = tableColumnCaseFormat;
        return this;
    }

    public CaseFormat getEntityFieldCaseFormat() {
        return this.entityFieldCaseFormat;
    }

    public SmartDbEntityGeneratorBuilder setEntityFieldCaseFormat(CaseFormat entityFieldCaseFormat) {
        this.entityFieldCaseFormat = entityFieldCaseFormat;
        return this;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public SmartDbEntityGeneratorBuilder setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public SmartDbEntityGeneratorBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SmartDbEntityGeneratorBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public SmartDbEntityGeneratorBuilder setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SmartDbEntityGeneratorBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public SmartDbEntityGeneratorBuilder setComment(boolean comment) {
        this.isComment = comment;
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public SmartDbEntityGeneratorBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public SmartDbEntityGeneratorBuilder setClassName(String className) {
        this.className = className;
        return this;
    }

    public Connection getConnection() throws Exception {
        Class.forName(this.driverClassName);
        return DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
    }

    public boolean isGenerateGetterSetter() {
        return this.isGenerateGetterSetter;
    }

    protected void releaseResources(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error("cannot releaseConnection Statement", (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error("cannot releaseConnection conn", (Throwable)e);
            }
        }
    }
}

