/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import javax.swing.filechooser.FileSystemView;
import net.lab1024.smartdb.annotation.PrimaryKey;
import net.lab1024.smartdb.annotation.TableAlias;
import net.lab1024.smartdb.codegenerator.SmartDbEntityGenerator;
import net.lab1024.smartdb.codegenerator.SmartDbEntityGeneratorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlEntityGenerator
extends SmartDbEntityGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(MysqlEntityGenerator.class);

    public MysqlEntityGenerator(SmartDbEntityGeneratorBuilder smartDbEntityGeneratorBuilder) {
        super(smartDbEntityGeneratorBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() {
        Connection con = null;
        PreparedStatement pStemt = null;
        ResultSet rs = null;
        try {
            con = this.smartDbEntityGeneratorBuilder.getConnection();
            ResultSet primaryColumnKeys = con.getMetaData().getPrimaryKeys(null, null, this.smartDbEntityGeneratorBuilder.getTableName());
            while (primaryColumnKeys.next()) {
                this.primaryKeyColumnNames.add(primaryColumnKeys.getString(4));
            }
            rs = con.getMetaData().getColumns(null, "%", this.smartDbEntityGeneratorBuilder.getTableName(), "%");
            while (rs.next()) {
                this.colRemarkList.add(rs.getString("REMARKS"));
            }
            LOG.debug("============\u5f00\u59cb \u89e3\u6790\u5217============");
            pStemt = con.prepareStatement(String.format("select * from %s ", this.smartDbEntityGeneratorBuilder.getTableName()));
            ResultSetMetaData rsmd = pStemt.getMetaData();
            int size = rsmd.getColumnCount();
            for (int i = 0; i < size; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                String fieldName = this.smartDbEntityGeneratorBuilder.getTableColumnCaseFormat().to(this.smartDbEntityGeneratorBuilder.getEntityFieldCaseFormat(), columnName);
                this.colNamesList.add(fieldName);
                LOG.debug(String.format("\u5217\u660e\u8f6c\u6362: %s ==> %s ", columnName, fieldName));
                String colType = rsmd.getColumnTypeName(i + 1);
                this.colTypesList.add(colType);
                if (colType.equalsIgnoreCase("datetime") || colType.equalsIgnoreCase("date") || colType.equalsIgnoreCase("time")) {
                    this.importUtilDate = true;
                }
                int columnDisplaySize = rsmd.getColumnDisplaySize(i + 1);
                this.colSizesList.add(columnDisplaySize);
            }
            LOG.debug("============\u7ed3\u675f \u89e3\u6790\u5217============");
            String classContent = this.generateClassContent();
            this.write2File(classContent);
            this.smartDbEntityGeneratorBuilder.releaseResources(null, pStemt, con);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            this.smartDbEntityGeneratorBuilder.releaseResources(null, pStemt, con);
        }
    }

    protected void parseTableInfo(Connection conn, PreparedStatement pStemt) {
    }

    protected void genEntityClassRemark(StringBuilder sb) {
        sb.append("package " + this.smartDbEntityGeneratorBuilder.getPackageName() + ";\r\n\r\n");
        if (this.importUtilDate) {
            sb.append("import java.util.Date;\r\n");
        }
        if (!this.primaryKeyColumnNames.isEmpty()) {
            sb.append("import " + PrimaryKey.class.getName() + ";\r\n");
        }
        sb.append("import " + TableAlias.class.getName() + ";\r\n");
        sb.append("\r\n/**\r\n");
        sb.append("* " + this.smartDbEntityGeneratorBuilder.getTableName() + "  \u5b9e\u4f53\u7c7b\r\n");
        sb.append("* \u8868\u5907\u6ce8\uff1a" + this.smartDbEntityGeneratorBuilder.getTableName() + "  \u5b9e\u4f53\u7c7b\r\n");
        sb.append("*/ \r\n");
    }

    protected void write2File(String content) {
        LOG.debug("============\u5f00\u59cb\u5199\u5165\u6587\u4ef6============");
        String dir = null;
        dir = this.smartDbEntityGeneratorBuilder.getEntityClassFileDir() != null && this.smartDbEntityGeneratorBuilder.getEntityClassFileDir().length() > 0 ? this.smartDbEntityGeneratorBuilder.getEntityClassFileDir() : FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile().getAbsolutePath();
        File classFile = new File(dir + File.separator + this.smartDbEntityGeneratorBuilder.getClassName() + ".java");
        try {
            if (classFile.exists()) {
                classFile.delete();
            }
            classFile.createNewFile();
            FileWriter fw = new FileWriter(classFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(content);
            pw.flush();
            pw.close();
            LOG.debug("============\u7ed3\u675f\u5199\u5165\u6587\u4ef6============");
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        LOG.info(String.format("\u8868:%s, \u7c7b\uff1a%s, \u8def\u5f84:%s", this.smartDbEntityGeneratorBuilder.getTableName(), this.smartDbEntityGeneratorBuilder.getClassName(), classFile.getAbsolutePath()));
    }

    protected String generateClassContent() {
        LOG.debug("============\u5f00\u59cb\u751f\u6210 \u7c7b============");
        StringBuilder sb = new StringBuilder();
        this.genEntityClassRemark(sb);
        this.genEntityClassName(sb);
        this.genEntityClassFields(sb);
        if (this.smartDbEntityGeneratorBuilder.isGenerateGetterSetter()) {
            this.genGetterSetterMethod(sb);
        }
        sb.append("}\r\n");
        LOG.debug("============\u7ed3\u675f\u751f\u6210 \u7c7b============");
        return sb.toString();
    }

    protected void genEntityClassName(StringBuilder sb) {
        sb.append("\r\n");
        sb.append("@" + TableAlias.class.getSimpleName() + "(\"" + this.smartDbEntityGeneratorBuilder.getTableName() + "\")\r\n");
        sb.append("public class " + this.smartDbEntityGeneratorBuilder.getClassName() + "{\r\n");
    }

    protected void genEntityClassFields(StringBuilder sb) {
        for (int i = 0; i < this.colNamesList.size(); ++i) {
            sb.append("\t/** " + (String)this.colRemarkList.get(i) + " (\u6700\u5927\u957f\u5ea6:" + String.valueOf(this.colSizesList.get(i)) + ",\u7c7b\u578b:" + (String)this.colTypesList.get(i) + ")  */\r\n");
            if (this.primaryKeyColumnNames.contains(this.colNamesList.get(i))) {
                sb.append("\t@" + PrimaryKey.class.getSimpleName() + "\r\n");
            }
            if (this.smartDbEntityGeneratorBuilder.isFieldBasicType()) {
                sb.append("\tprivate " + this.sqlType2JavaTypeForBasic((String)this.colTypesList.get(i)) + " " + (String)this.colNamesList.get(i) + ";\r\n");
                continue;
            }
            sb.append("\tprivate " + this.sqlType2JavaTypeForRefer((String)this.colTypesList.get(i)) + " " + (String)this.colNamesList.get(i) + ";\r\n");
        }
    }

    protected void genGetterSetterMethod(StringBuilder sb) {
        for (int i = 0; i < this.colNamesList.size(); ++i) {
            sb.append("\t/** " + (String)this.colRemarkList.get(i) + " (\u6700\u5927\u957f\u5ea6:" + this.colSizesList.add(i) + ",\u7c7b\u578b:" + (String)this.colTypesList.get(i) + ")  */\r\n");
            if (this.smartDbEntityGeneratorBuilder.isFieldBasicType()) {
                sb.append("\tpublic void set" + this.initcap((String)this.colNamesList.get(i)) + "(" + this.sqlType2JavaTypeForBasic((String)this.colTypesList.get(i)) + " " + (String)this.colNamesList.get(i) + "){\r\n");
            } else {
                sb.append("\tpublic void set" + this.initcap((String)this.colNamesList.get(i)) + "(" + this.sqlType2JavaTypeForRefer((String)this.colTypesList.get(i)) + " " + (String)this.colNamesList.get(i) + "){\r\n");
            }
            sb.append("\tthis." + (String)this.colNamesList.get(i) + "=" + (String)this.colNamesList.get(i) + ";\r\n");
            sb.append("\t}\r\n");
            sb.append("\t/** " + (String)this.colRemarkList.get(i) + " (\u6700\u5927\u957f\u5ea6:" + this.colSizesList.add(i) + ",\u7c7b\u578b:" + (String)this.colTypesList.get(i) + ")  */\r\n");
            if (this.smartDbEntityGeneratorBuilder.isFieldBasicType()) {
                sb.append("\tpublic " + this.sqlType2JavaTypeForBasic((String)this.colTypesList.get(i)) + " get" + this.initcap((String)this.colNamesList.get(i)) + "(){\r\n");
            } else {
                sb.append("\tpublic " + this.sqlType2JavaTypeForRefer((String)this.colTypesList.get(i)) + " get" + this.initcap((String)this.colNamesList.get(i)) + "(){\r\n");
            }
            sb.append("\t\treturn " + (String)this.colNamesList.get(i) + ";\r\n");
            sb.append("\t}\r\n");
        }
    }

    protected String sqlType2JavaTypeForRefer(String sqlType) {
        if (sqlType.equalsIgnoreCase("bit")) {
            return "Boolean";
        }
        if (sqlType.equalsIgnoreCase("tinyint")) {
            return "Byte";
        }
        if (sqlType.equalsIgnoreCase("smallint")) {
            return "Short";
        }
        if (sqlType.equalsIgnoreCase("int")) {
            return "Integer";
        }
        if (sqlType.equalsIgnoreCase("bigint")) {
            return "Long";
        }
        if (sqlType.equalsIgnoreCase("float")) {
            return "Float";
        }
        if (sqlType.equalsIgnoreCase("numeric") || sqlType.equalsIgnoreCase("real") || sqlType.equalsIgnoreCase("money") || sqlType.equalsIgnoreCase("smallmoney")) {
            return "Double";
        }
        if (sqlType.equalsIgnoreCase("decimal")) {
            return "BigDecimal";
        }
        if (sqlType.equalsIgnoreCase("varchar") || sqlType.equalsIgnoreCase("char") || sqlType.equalsIgnoreCase("nvarchar") || sqlType.equalsIgnoreCase("nchar") || sqlType.equalsIgnoreCase("text")) {
            return "String";
        }
        if (sqlType.equalsIgnoreCase("datetime")) {
            return "Date";
        }
        if (sqlType.equalsIgnoreCase("image")) {
            return "Blod";
        }
        if (sqlType.equalsIgnoreCase("TIMESTAMP")) {
            return "Timestamp";
        }
        return null;
    }

    protected String sqlType2JavaTypeForBasic(String sqlType) {
        if (sqlType.equalsIgnoreCase("bit")) {
            return "boolean";
        }
        if (sqlType.equalsIgnoreCase("tinyint")) {
            return "byte";
        }
        if (sqlType.equalsIgnoreCase("smallint")) {
            return "short";
        }
        if (sqlType.equalsIgnoreCase("int")) {
            return "int";
        }
        if (sqlType.equalsIgnoreCase("bigint")) {
            return "long";
        }
        if (sqlType.equalsIgnoreCase("float")) {
            return "float";
        }
        if (sqlType.equalsIgnoreCase("numeric") || sqlType.equalsIgnoreCase("real") || sqlType.equalsIgnoreCase("money") || sqlType.equalsIgnoreCase("smallmoney")) {
            return "double";
        }
        if (sqlType.equalsIgnoreCase("decimal")) {
            return "BigDecimal";
        }
        if (sqlType.equalsIgnoreCase("varchar") || sqlType.equalsIgnoreCase("char") || sqlType.equalsIgnoreCase("nvarchar") || sqlType.equalsIgnoreCase("nchar") || sqlType.equalsIgnoreCase("text")) {
            return "String";
        }
        if (sqlType.equalsIgnoreCase("datetime")) {
            return "Date";
        }
        if (sqlType.equalsIgnoreCase("image")) {
            return "Blod";
        }
        if (sqlType.equalsIgnoreCase("TIMESTAMP")) {
            return "Timestamp";
        }
        return null;
    }

    protected String initcap(String str) {
        char[] ch = str.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }
}

