/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.smartdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import net.lab1024.smartdb.SmartDb;
import net.lab1024.smartdb.filter.SmartDbFilter;
import net.lab1024.smartdb.filter.SmartDbFilterChainImpl;

class SmartDbProxy
implements InvocationHandler {
    private SmartDb db;
    private SmartDbFilterChainImpl smartDbFilterChain;

    SmartDbProxy(SmartDb db, List<SmartDbFilter> filters) {
        this.db = db;
        this.smartDbFilterChain = new SmartDbFilterChainImpl();
        if (filters != null) {
            for (SmartDbFilter filter : filters) {
                this.smartDbFilterChain.addFilter(filter);
            }
        }
    }

    SmartDb getInstance() {
        Class<?>[] interfaces = this.db.getClass().getInterfaces();
        Class<?> interfaceClass = null;
        for (Class<?> anInterface : interfaces) {
            if (!SmartDb.class.isAssignableFrom(anInterface)) continue;
            interfaceClass = anInterface;
            break;
        }
        return (SmartDb)Proxy.newProxyInstance(this.db.getClass().getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SmartDbFilterChainImpl chain = new SmartDbFilterChainImpl();
        return chain.doFilter(this.db, method, args);
    }
}

