/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.mp.bean.WxMpMassNews;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxMpMassNewsGsonAdapter
implements JsonSerializer<WxMpMassNews> {
    public JsonElement serialize(WxMpMassNews message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject newsJson = new JsonObject();
        JsonArray articleJsonArray = new JsonArray();
        for (WxMpMassNews.WxMpMassNewsArticle article : message.getArticles()) {
            JsonObject articleJson = new JsonObject();
            articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
            articleJson.addProperty("title", article.getTitle());
            articleJson.addProperty("content", article.getContent());
            if (null != article.getAuthor()) {
                articleJson.addProperty("author", article.getAuthor());
            }
            if (null != article.getContentSourceUrl()) {
                articleJson.addProperty("content_source_url", article.getContentSourceUrl());
            }
            if (null != article.getDigest()) {
                articleJson.addProperty("digest", article.getDigest());
            }
            articleJson.addProperty("show_cover_pic", article.isShowCoverPic() ? "1" : "0");
            articleJsonArray.add((JsonElement)articleJson);
        }
        newsJson.add("articles", (JsonElement)articleJsonArray);
        return newsJson;
    }
}

