/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.snowflake;

import com.google.common.base.MoreObjects;
import java.time.ZoneId;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.provider.IdGeneratorProvider;
import me.ahoo.cosid.snowflake.ClockSyncSnowflakeId;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.SecondSnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import me.ahoo.cosid.spring.boot.starter.IdConverterDefinition;
import me.ahoo.cosid.spring.boot.starter.Namespaces;
import me.ahoo.cosid.spring.boot.starter.machine.MachineProperties;
import me.ahoo.cosid.spring.boot.starter.snowflake.CustomizeSnowflakeIdProperties;
import me.ahoo.cosid.spring.boot.starter.snowflake.SnowflakeIdConverterDecorator;
import me.ahoo.cosid.spring.boot.starter.snowflake.SnowflakeIdProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;

public class SnowflakeIdBeanRegistrar
implements InitializingBean {
    private final CosIdProperties cosIdProperties;
    private final MachineProperties machineProperties;
    private final SnowflakeIdProperties snowflakeIdProperties;
    private final InstanceId instanceId;
    private final IdGeneratorProvider idGeneratorProvider;
    private final MachineIdDistributor machineIdDistributor;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;
    private final ConfigurableApplicationContext applicationContext;
    @Nullable
    private final CustomizeSnowflakeIdProperties customizeSnowflakeIdProperties;

    public SnowflakeIdBeanRegistrar(CosIdProperties cosIdProperties, MachineProperties machineProperties, SnowflakeIdProperties snowflakeIdProperties, InstanceId instanceId, IdGeneratorProvider idGeneratorProvider, MachineIdDistributor machineIdDistributor, ClockBackwardsSynchronizer clockBackwardsSynchronizer, ConfigurableApplicationContext applicationContext, @Nullable CustomizeSnowflakeIdProperties customizeSnowflakeIdProperties) {
        this.cosIdProperties = cosIdProperties;
        this.machineProperties = machineProperties;
        this.snowflakeIdProperties = snowflakeIdProperties;
        this.instanceId = instanceId;
        this.idGeneratorProvider = idGeneratorProvider;
        this.machineIdDistributor = machineIdDistributor;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
        this.applicationContext = applicationContext;
        this.customizeSnowflakeIdProperties = customizeSnowflakeIdProperties;
    }

    public void afterPropertiesSet() {
        this.register();
    }

    public void register() {
        SnowflakeIdProperties.ShardIdDefinition shareIdDefinition;
        if (this.customizeSnowflakeIdProperties != null) {
            this.customizeSnowflakeIdProperties.customize(this.snowflakeIdProperties);
        }
        if ((shareIdDefinition = this.snowflakeIdProperties.getShare()).isEnabled()) {
            this.registerIdDefinition("__share__", shareIdDefinition);
        }
        this.snowflakeIdProperties.getProvider().forEach(this::registerIdDefinition);
    }

    private void registerIdDefinition(String name, SnowflakeIdProperties.IdDefinition idDefinition) {
        SnowflakeId idGenerator = this.createIdGen(idDefinition, this.clockBackwardsSynchronizer);
        this.registerSnowflakeId(name, idGenerator);
    }

    private void registerSnowflakeId(String name, SnowflakeId snowflakeId) {
        if (this.idGeneratorProvider.get(name).isEmpty()) {
            this.idGeneratorProvider.set(name, (IdGenerator)snowflakeId);
        }
        String beanName = name + "SnowflakeId";
        this.applicationContext.getBeanFactory().registerSingleton(beanName, (Object)snowflakeId);
    }

    private SnowflakeId createIdGen(SnowflakeIdProperties.IdDefinition idDefinition, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        long epoch = this.getEpoch(idDefinition);
        int machineBit = (Integer)MoreObjects.firstNonNull((Object)idDefinition.getMachineBit(), (Object)this.machineProperties.getMachineBit());
        String namespace = Namespaces.firstNotBlank(idDefinition.getNamespace(), this.cosIdProperties.getNamespace());
        int machineId = this.machineIdDistributor.distribute(namespace, machineBit, this.instanceId, this.machineProperties.getSafeGuardDuration()).getMachineId();
        Object snowflakeId = SnowflakeIdProperties.IdDefinition.TimestampUnit.SECOND.equals((Object)idDefinition.getTimestampUnit()) ? new SecondSnowflakeId(epoch, idDefinition.getTimestampBit(), machineBit, idDefinition.getSequenceBit(), machineId, idDefinition.getSequenceResetThreshold()) : new MillisecondSnowflakeId(epoch, idDefinition.getTimestampBit(), machineBit, idDefinition.getSequenceBit(), machineId, idDefinition.getSequenceResetThreshold());
        if (idDefinition.isClockSync()) {
            snowflakeId = new ClockSyncSnowflakeId((SnowflakeId)snowflakeId, clockBackwardsSynchronizer);
        }
        IdConverterDefinition converterDefinition = idDefinition.getConverter();
        ZoneId zoneId = ZoneId.of(this.snowflakeIdProperties.getZoneId());
        return (SnowflakeId)new SnowflakeIdConverterDecorator((SnowflakeId)snowflakeId, converterDefinition, zoneId).decorate();
    }

    private long getEpoch(SnowflakeIdProperties.IdDefinition idDefinition) {
        if (idDefinition.getEpoch() > 0L) {
            return idDefinition.getEpoch();
        }
        return this.snowflakeIdProperties.getEpoch();
    }
}

