/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.zookeeper;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.zookeeper.ConditionalOnCosIdZookeeperEnabled;
import me.ahoo.cosid.spring.boot.starter.zookeeper.CosIdZookeeperProperties;
import me.ahoo.cosid.zookeeper.ZookeeperIdSegmentDistributorFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnCosIdEnabled
@ConditionalOnCosIdZookeeperEnabled
@ConditionalOnClass(value={ZookeeperIdSegmentDistributorFactory.class})
@EnableConfigurationProperties(value={CosIdZookeeperProperties.class})
public class CosIdZookeeperAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CosIdZookeeperAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy cosIdRetryPolicy(CosIdZookeeperProperties zookeeperProperties) {
        CosIdZookeeperProperties.Retry retry = zookeeperProperties.getRetry();
        return new ExponentialBackoffRetry(retry.getBaseSleepTimeMs(), retry.getMaxRetries(), retry.getMaxSleepMs());
    }

    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    public CuratorFramework cosidCuratorFramework(CosIdZookeeperProperties zookeeperProperties, RetryPolicy retryPolicy) throws InterruptedException {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        builder.connectString(zookeeperProperties.getConnectString());
        builder.sessionTimeoutMs((int)zookeeperProperties.getSessionTimeout().toMillis()).connectionTimeoutMs((int)zookeeperProperties.getConnectionTimeout().toMillis()).retryPolicy(retryPolicy);
        CuratorFramework curator = builder.build();
        curator.start();
        curator.blockUntilConnected((int)zookeeperProperties.getBlockUntilConnectedWait().toMillis(), TimeUnit.MILLISECONDS);
        return curator;
    }
}

