/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.ThreadSafe;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import me.ahoo.cosid.IdGeneratorDecorator;
import me.ahoo.cosid.converter.RadixIdConverter;
import me.ahoo.cosid.cosid.FriendlyIdStateParser;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SecondSnowflakeId;
import me.ahoo.cosid.snowflake.SecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeIdState;

@ThreadSafe
public abstract class SnowflakeIdStateParser {
    public static final String DELIMITER = "-";
    protected final ZoneId zoneId;
    protected final long epoch;
    protected final int sequenceBit;
    protected final long sequenceMask;
    protected final int machineBit;
    protected final long machineMask;
    protected final int machineLeft;
    protected final int timestampBit;
    protected final long timestampMask;
    protected final int timestampLeft;
    protected final boolean padStart;
    private final int machineCharSize;
    private final int sequenceCharSize;

    public SnowflakeIdStateParser(long epoch, int timestampBit, int machineBit, int sequenceBit) {
        this(epoch, timestampBit, machineBit, sequenceBit, ZoneId.systemDefault(), false);
    }

    public SnowflakeIdStateParser(long epoch, int timestampBit, int machineBit, int sequenceBit, ZoneId zoneId, boolean padStart) {
        this.epoch = epoch;
        this.sequenceMask = this.getMask(sequenceBit);
        this.sequenceBit = sequenceBit;
        this.machineMask = this.getMask(machineBit);
        this.machineBit = machineBit;
        this.timestampMask = this.getMask(timestampBit);
        this.timestampBit = timestampBit;
        this.zoneId = zoneId;
        this.machineLeft = sequenceBit;
        this.timestampLeft = this.machineLeft + machineBit;
        this.padStart = padStart;
        this.machineCharSize = RadixIdConverter.maxCharSize(10, machineBit);
        this.sequenceCharSize = RadixIdConverter.maxCharSize(10, sequenceBit);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public boolean isPadStart() {
        return this.padStart;
    }

    public int getMachineCharSize() {
        return this.machineCharSize;
    }

    public int getSequenceCharSize() {
        return this.sequenceCharSize;
    }

    protected abstract DateTimeFormatter getDateTimeFormatter();

    protected abstract LocalDateTime getTimestamp(long var1);

    protected abstract long getDiffTime(LocalDateTime var1);

    public SnowflakeIdState parse(String friendlyId) {
        Preconditions.checkNotNull((Object)friendlyId, (Object)"friendlyId can not be null!");
        List segments = Splitter.on((String)DELIMITER).trimResults().omitEmptyStrings().splitToList((CharSequence)friendlyId);
        if (segments.size() != 3) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"friendlyId :[%s] Illegal.", (Object[])new Object[]{friendlyId}));
        }
        String timestampStr = (String)segments.get(0);
        LocalDateTime timestamp = LocalDateTime.parse(timestampStr, this.getDateTimeFormatter());
        long machineId = Long.parseLong((String)segments.get(1));
        long sequence = Long.parseLong((String)segments.get(2));
        long diffTime = this.getDiffTime(timestamp);
        long id = diffTime << this.timestampLeft | machineId << this.machineLeft | sequence;
        return SnowflakeIdState.builder().id(id).machineId((int)machineId).sequence(sequence).timestamp(timestamp).friendlyId(friendlyId).build();
    }

    public SnowflakeIdState parse(long id) {
        int machineId = this.parseMachineId(id);
        long sequence = this.parseSequence(id);
        LocalDateTime timestamp = this.parseTimestamp(id);
        String friendlyId = timestamp.format(this.getDateTimeFormatter()) + DELIMITER + FriendlyIdStateParser.intAsString(this.padStart, machineId, this.machineCharSize) + DELIMITER + FriendlyIdStateParser.intAsString(this.padStart, (int)sequence, this.sequenceCharSize);
        return SnowflakeIdState.builder().id(id).machineId(machineId).sequence(sequence).timestamp(timestamp).friendlyId(friendlyId).build();
    }

    private long getMask(long bits) {
        return -1L << (int)bits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public LocalDateTime parseTimestamp(long id) {
        long diffTime = id >> this.timestampLeft & this.timestampMask;
        return this.getTimestamp(diffTime);
    }

    public int parseMachineId(long id) {
        return (int)(id >> this.machineLeft & this.machineMask);
    }

    public long parseSequence(long id) {
        return id & this.sequenceMask;
    }

    public static SnowflakeIdStateParser of(SnowflakeId snowflakeId) {
        return SnowflakeIdStateParser.of(snowflakeId, ZoneId.systemDefault(), false);
    }

    public static SnowflakeIdStateParser of(SnowflakeId snowflakeId, ZoneId zoneId, boolean padStart) {
        SnowflakeId actual = IdGeneratorDecorator.getActual(snowflakeId);
        if (actual instanceof SecondSnowflakeId) {
            return SecondSnowflakeIdStateParser.of(actual, zoneId, padStart);
        }
        return MillisecondSnowflakeIdStateParser.of(actual, zoneId, padStart);
    }
}

