/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.Generated;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.IdSegmentChain;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.NextIdSegmentExpiredException;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.segment.concurrent.AffinityJob;
import me.ahoo.cosid.segment.concurrent.PrefetchWorker;
import me.ahoo.cosid.segment.concurrent.PrefetchWorkerExecutorService;
import me.ahoo.cosid.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentChainId
implements SegmentId {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentChainId.class);
    public static final int DEFAULT_SAFE_DISTANCE = 2;
    private final long idSegmentTtl;
    private final int safeDistance;
    private final IdSegmentDistributor maxIdDistributor;
    private final PrefetchJob prefetchJob;
    private volatile IdSegmentChain headChain;

    public SegmentChainId(IdSegmentDistributor maxIdDistributor) {
        this(Long.MAX_VALUE, 2, maxIdDistributor, PrefetchWorkerExecutorService.DEFAULT);
    }

    public SegmentChainId(long idSegmentTtl, int safeDistance, IdSegmentDistributor maxIdDistributor, PrefetchWorkerExecutorService prefetchWorkerExecutorService) {
        Preconditions.checkArgument((idSegmentTtl > 0L ? 1 : 0) != 0, (Object)Strings.lenientFormat((String)"Illegal idSegmentTtl parameter:[%s].", (Object[])new Object[]{idSegmentTtl}));
        Preconditions.checkArgument((safeDistance > 0 ? 1 : 0) != 0, (Object)"The safety distance must be greater than 0.");
        this.headChain = IdSegmentChain.newRoot(maxIdDistributor.allowReset());
        this.idSegmentTtl = idSegmentTtl;
        this.safeDistance = safeDistance;
        this.maxIdDistributor = maxIdDistributor;
        this.prefetchJob = new PrefetchJob(this.headChain);
        prefetchWorkerExecutorService.submit(this.prefetchJob);
    }

    @Override
    public IdSegment current() {
        return this.headChain;
    }

    public IdSegmentChain getHead() {
        return this.headChain;
    }

    private void forward(IdSegmentChain forwardChain) {
        if (this.headChain.getVersion() >= forwardChain.getVersion()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Forward [{}] - [{}] -> [{}].", new Object[]{this.maxIdDistributor.getNamespacedName(), this.headChain, forwardChain});
        }
        if (this.maxIdDistributor.allowReset()) {
            this.headChain = forwardChain;
        } else if (forwardChain.compareTo(this.headChain) > 0) {
            this.headChain = forwardChain;
        }
    }

    private IdSegmentChain generateNext(IdSegmentChain previousChain, int segments) {
        return this.maxIdDistributor.nextIdSegmentChain(previousChain, segments, this.idSegmentTtl);
    }

    @Override
    public long generate() {
        while (true) {
            block6: {
                for (IdSegmentChain currentChain = this.headChain; currentChain != null; currentChain = currentChain.getNext()) {
                    long nextSeq;
                    if (!currentChain.isAvailable() || currentChain.isOverflow(nextSeq = currentChain.incrementAndGet())) continue;
                    this.forward(currentChain);
                    return nextSeq;
                }
                try {
                    IdSegmentChain preIdSegmentChain = this.headChain;
                    if (preIdSegmentChain.trySetNext(preChain -> this.generateNext((IdSegmentChain)preChain, this.safeDistance))) {
                        IdSegmentChain nextChain = preIdSegmentChain.getNext();
                        this.forward(nextChain);
                        if (log.isDebugEnabled()) {
                            log.debug("Generate [{}] - headChain.version:[{}->{}].", new Object[]{this.maxIdDistributor.getNamespacedName(), preIdSegmentChain.getVersion(), nextChain.getVersion()});
                        }
                    }
                }
                catch (NextIdSegmentExpiredException nextIdSegmentExpiredException) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn("Generate [{}] - gave up this next IdSegmentChain.", (Object)this.maxIdDistributor.getNamespacedName(), (Object)nextIdSegmentExpiredException);
                }
            }
            this.prefetchJob.hungry();
        }
    }

    public class PrefetchJob
    implements AffinityJob {
        private static final int MAX_PREFETCH_DISTANCE = 100000000;
        private static final long hungerThreshold = 5L;
        private volatile PrefetchWorker prefetchWorker;
        private int prefetchDistance;
        private IdSegmentChain tailChain;
        private volatile long lastHungerTime;

        public PrefetchJob(IdSegmentChain tailChain) {
            this.prefetchDistance = SegmentChainId.this.safeDistance;
            this.tailChain = tailChain;
        }

        @Override
        public String getJobId() {
            return SegmentChainId.this.maxIdDistributor.getNamespacedName();
        }

        @Override
        public void setHungerTime(long hungerTime) {
            this.lastHungerTime = hungerTime;
        }

        @Override
        public PrefetchWorker getPrefetchWorker() {
            return this.prefetchWorker;
        }

        @Override
        public void setPrefetchWorker(PrefetchWorker prefetchWorker) {
            if (this.prefetchWorker != null) {
                return;
            }
            this.prefetchWorker = prefetchWorker;
        }

        @Override
        public void run() {
            this.prefetch();
        }

        public void prefetch() {
            long wakeupTimeGap = Clock.SYSTEM.secondTime() - this.lastHungerTime;
            boolean hunger = wakeupTimeGap < 5L;
            int prePrefetchDistance = this.prefetchDistance;
            if (hunger) {
                this.prefetchDistance = Math.min(Math.multiplyExact(this.prefetchDistance, 2), 100000000);
                if (log.isInfoEnabled()) {
                    log.info("Prefetch [{}] - Hunger, Safety distance expansion.[{}->{}]", new Object[]{SegmentChainId.this.maxIdDistributor.getNamespacedName(), prePrefetchDistance, this.prefetchDistance});
                }
            } else {
                this.prefetchDistance = Math.max(Math.floorDiv(this.prefetchDistance, 2), SegmentChainId.this.safeDistance);
                if (prePrefetchDistance > this.prefetchDistance && log.isInfoEnabled()) {
                    log.info("Prefetch [{}] - Full, Safety distance shrinks.[{}->{}]", new Object[]{SegmentChainId.this.maxIdDistributor.getNamespacedName(), prePrefetchDistance, this.prefetchDistance});
                }
            }
            IdSegmentChain availableHeadChain = SegmentChainId.this.headChain;
            while (!availableHeadChain.getIdSegment().isAvailable()) {
                if ((availableHeadChain = availableHeadChain.getNext()) != null) continue;
                availableHeadChain = this.tailChain;
                break;
            }
            SegmentChainId.this.forward(availableHeadChain);
            int headToTailGap = availableHeadChain.gap(this.tailChain, SegmentChainId.this.maxIdDistributor.getStep());
            int safeGap = SegmentChainId.this.safeDistance - headToTailGap;
            if (safeGap <= 0 && !hunger) {
                if (log.isTraceEnabled()) {
                    log.trace("Prefetch [{}] - safeGap is less than or equal to 0, and is not hungry - headChain.version:[{}] - tailChain.version:[{}].", new Object[]{SegmentChainId.this.maxIdDistributor.getNamespacedName(), availableHeadChain.getVersion(), this.tailChain.getVersion()});
                }
                return;
            }
            int prefetchSegments = hunger ? this.prefetchDistance : safeGap;
            this.appendChain(availableHeadChain, prefetchSegments);
        }

        private void appendChain(IdSegmentChain availableHeadChain, int prefetchSegments) {
            block5: {
                if (log.isDebugEnabled()) {
                    log.debug("AppendChain [{}] - headChain.version:[{}] - tailChain.version:[{}] - prefetchSegments:[{}].", new Object[]{SegmentChainId.this.maxIdDistributor.getNamespacedName(), availableHeadChain.getVersion(), this.tailChain.getVersion(), prefetchSegments});
                }
                try {
                    IdSegmentChain preTail = this.tailChain;
                    this.tailChain = this.tailChain.ensureSetNext(preChain -> SegmentChainId.this.generateNext((IdSegmentChain)preChain, prefetchSegments)).getNext();
                    while (this.tailChain.getNext() != null) {
                        this.tailChain = this.tailChain.getNext();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("AppendChain [{}] - restTail - tailChain.version:[{}:{}->{}] .", new Object[]{SegmentChainId.this.maxIdDistributor.getNamespacedName(), preTail.gap(this.tailChain, SegmentChainId.this.maxIdDistributor.getStep()), preTail.getVersion(), this.tailChain.getVersion()});
                    }
                }
                catch (NextIdSegmentExpiredException nextIdSegmentExpiredException) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn("AppendChain [{}] - gave up this next IdSegmentChain.", (Object)SegmentChainId.this.maxIdDistributor.getNamespacedName(), (Object)nextIdSegmentExpiredException);
                }
            }
        }
    }
}

