/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import lombok.Generated;
import me.ahoo.cosid.segment.DefaultIdSegment;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.SegmentId;
import me.ahoo.cosid.segment.grouped.GroupedAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSegmentId
implements SegmentId {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSegmentId.class);
    private final long idSegmentTtl;
    private final IdSegmentDistributor maxIdDistributor;
    @GuardedBy(value="this")
    private volatile IdSegment segment = DefaultIdSegment.OVERFLOW;

    public DefaultSegmentId(IdSegmentDistributor maxIdDistributor) {
        this(Long.MAX_VALUE, maxIdDistributor);
    }

    public DefaultSegmentId(long idSegmentTtl, IdSegmentDistributor maxIdDistributor) {
        Preconditions.checkArgument((idSegmentTtl > 0L ? 1 : 0) != 0, (String)"idSegmentTtl:[%s] must be greater than 0.", (long)idSegmentTtl);
        this.idSegmentTtl = idSegmentTtl;
        this.maxIdDistributor = maxIdDistributor;
    }

    @Override
    public IdSegment current() {
        return this.segment;
    }

    @Override
    public long generate() {
        long nextSeq;
        if (this.maxIdDistributor.getStep() == 1L) {
            GroupedAccessor.setIfNotNever(this.maxIdDistributor.group());
            return this.maxIdDistributor.nextMaxId();
        }
        if (this.segment.isAvailable() && !this.segment.isOverflow(nextSeq = this.segment.incrementAndGet())) {
            return nextSeq;
        }
        DefaultSegmentId defaultSegmentId = this;
        synchronized (defaultSegmentId) {
            while (true) {
                if (this.segment.isAvailable() && !this.segment.isOverflow(nextSeq = this.segment.incrementAndGet())) {
                    return nextSeq;
                }
                IdSegment nextIdSegment = this.maxIdDistributor.nextIdSegment(this.idSegmentTtl);
                if (!this.maxIdDistributor.allowReset()) {
                    this.segment.ensureNextIdSegment(nextIdSegment);
                }
                this.segment = nextIdSegment;
            }
        }
    }
}

