/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.segment;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import me.ahoo.cosid.segment.IdSegment;
import me.ahoo.cosid.segment.grouped.GroupedAccessor;
import me.ahoo.cosid.segment.grouped.GroupedKey;
import me.ahoo.cosid.util.Clock;

public class DefaultIdSegment
implements IdSegment {
    public static final DefaultIdSegment OVERFLOW = new DefaultIdSegment(-1L, 0L, Clock.SYSTEM.secondTime(), Long.MAX_VALUE, GroupedKey.NEVER);
    private final long maxId;
    private final long offset;
    private final long step;
    private volatile long sequence;
    private final long fetchTime;
    private final long ttl;
    private final GroupedKey group;
    private static final AtomicLongFieldUpdater<DefaultIdSegment> S = AtomicLongFieldUpdater.newUpdater(DefaultIdSegment.class, "sequence");

    public DefaultIdSegment(long maxId, long step) {
        this(maxId, step, Clock.SYSTEM.secondTime(), Long.MAX_VALUE, GroupedKey.NEVER);
    }

    public DefaultIdSegment(long maxId, long step, long fetchTime, long ttl, GroupedKey group) {
        Preconditions.checkArgument((ttl > 0L ? 1 : 0) != 0, (String)"ttl:[%s] must be greater than 0.", (long)ttl);
        this.maxId = maxId;
        this.step = step;
        this.sequence = this.offset = maxId - step;
        this.fetchTime = fetchTime;
        this.ttl = ttl;
        this.group = group;
    }

    @Override
    public GroupedKey group() {
        return this.group;
    }

    @Override
    public long getFetchTime() {
        return this.fetchTime;
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public long getStep() {
        return this.step;
    }

    @Override
    public long incrementAndGet() {
        if (this.isOverflow()) {
            return -1L;
        }
        long nextSeq = S.incrementAndGet(this);
        if (this.isOverflow(nextSeq)) {
            return -1L;
        }
        GroupedAccessor.setIfNotNever(this.group());
        return nextSeq;
    }

    public String toString() {
        return "DefaultIdSegment{maxId=" + this.maxId + ", offset=" + this.offset + ", step=" + this.step + ", sequence=" + this.sequence + ", fetchTime=" + this.fetchTime + ", ttl=" + this.ttl + "}";
    }
}

