/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.provider;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.IdGeneratorProvider;

@ThreadSafe
public class DefaultIdGeneratorProvider
implements IdGeneratorProvider {
    public static final IdGeneratorProvider INSTANCE = new DefaultIdGeneratorProvider();
    private volatile IdGenerator shareIdGenerator;
    private final ConcurrentHashMap<String, IdGenerator> nameMapIdGen = new ConcurrentHashMap();

    @Override
    public IdGenerator getShare() {
        return this.shareIdGenerator;
    }

    @Override
    public void setShare(IdGenerator idGenerator) {
        this.shareIdGenerator = idGenerator;
        this.nameMapIdGen.put("__share__", idGenerator);
    }

    @Override
    public IdGenerator removeShare() {
        this.shareIdGenerator = null;
        return this.nameMapIdGen.remove("__share__");
    }

    @Override
    public Optional<IdGenerator> get(String name) {
        IdGenerator idGen = this.nameMapIdGen.get(name);
        return Optional.ofNullable(idGen);
    }

    @Override
    public IdGenerator remove(String name) {
        if ("__share__".equals(name)) {
            return this.removeShare();
        }
        return this.nameMapIdGen.remove(name);
    }

    @Override
    public void set(String name, IdGenerator idGenerator) {
        if ("__share__".equals(name)) {
            this.setShare(idGenerator);
            return;
        }
        this.nameMapIdGen.put(name, idGenerator);
    }

    @Override
    public void clear() {
        this.shareIdGenerator = null;
        this.nameMapIdGen.clear();
    }

    @Override
    public Set<Map.Entry<String, IdGenerator>> entries() {
        return this.nameMapIdGen.entrySet();
    }

    @Override
    public Collection<IdGenerator> getAll() {
        return this.nameMapIdGen.values();
    }
}

